/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.tasks.adapt;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.Publisher;
import com.vmware.dr.ui.tools.reactive.Stream;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.reactive.impl.Streams;
import com.vmware.srm.client.infrastructure.pc.utils.PCUtil;
import com.vmware.srm.client.infrastructure.tasks.adapt.MultiTaskAdapter;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.topology.client.vmomi.availability.hms.HmsService;
import com.vmware.vim.binding.hms.ChangeManager;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vim.vmomi.core.Future;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HmsTaskAdapter
extends MultiTaskAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HmsTaskAdapter.class);
    private static final String HMS_TASK_TYPE = "HmsTask";
    private final ServersView _view;

    public HmsTaskAdapter(ServersView view) {
        this._view = view;
    }

    @Override
    protected Promise<Collection<TaskInfo>> getUpdates(Set<ManagedObjectReference> tasks) {
        HashMap<String, Set> tasksByGuid = new HashMap<String, Set>();
        for (ManagedObjectReference taskRef : tasks) {
            String serverGuid = taskRef.getServerGuid();
            if (serverGuid == null) {
                LOGGER.error("No GUID for task '{}'", (Object)taskRef);
                return Promises.reject((Exception)new IllegalArgumentException("No GUID for task '" + taskRef + "'"));
            }
            Set value = tasksByGuid.computeIfAbsent(taskRef.getServerGuid(), guid -> new HashSet());
            value.add(taskRef);
        }
        Stream infos = Streams.empty();
        for (Map.Entry e : tasksByGuid.entrySet()) {
            infos = infos.merge(new Publisher[]{this._view.getServerBy((String)e.getKey()).thenCompose(hms -> this.getUpdatesFromServer((HmsService)hms.service(), (String)e.getKey(), (Set)e.getValue()))});
        }
        return infos.reduce(new ArrayList(), (list, coll) -> {
            list.addAll(coll);
            return list;
        });
    }

    private Promise<Collection<TaskInfo>> getUpdatesFromServer(HmsService service, String guid, Set<ManagedObjectReference> tasks) {
        return service.getContent().thenCompose(content -> {
            ChangeManager chm = (ChangeManager)service.createStub(content.getChangeManager());
            ChangeManager.ObjectsPropertiesSpec[] specs = new ChangeManager.ObjectsPropertiesSpec[]{new ChangeManager.ObjectsPropertiesSpec(new PropertyCollector.PropertySpec[]{PCUtil.createPropertySpec(HMS_TASK_TYPE, "info")}, tasks.toArray(new ManagedObjectReference[0]))};
            FuturePromise result = new FuturePromise();
            chm.fetchProperties(specs, (Future)result);
            return result;
        }).thenCompose(props -> {
            ChangeManager.MissingProperty[] missingPropeties;
            Object[] missingObjects = props.getMissingObjects();
            if (ArrayUtils.isNotEmpty((Object[])missingObjects)) {
                LOGGER.warn("Failed to get task progress for: {}", Arrays.asList(missingObjects));
                Exception fault = Arrays.stream(missingObjects).map(ChangeManager.MissingObject::getFault).filter(Objects::nonNull).findFirst().orElseGet(IllegalArgumentException::new);
                return Promises.reject((Exception)fault);
            }
            ChangeManager.ObjectProperties[] objProps = props.getProperties();
            if (objProps == null) {
                objProps = new ChangeManager.ObjectProperties[]{};
            }
            if ((missingPropeties = (ChangeManager.MissingProperty[])Arrays.stream(objProps).map(ChangeManager.ObjectProperties::getMissingProperties).filter(ArrayUtils::isNotEmpty).findFirst().orElse(null)) != null) {
                LOGGER.warn("Failed to get info property for: {}", Arrays.asList(missingPropeties));
                Exception fault = Arrays.stream(missingPropeties).map(ChangeManager.MissingProperty::getFault).filter(Objects::nonNull).findFirst().orElseGet(IllegalArgumentException::new);
                return Promises.reject((Exception)fault);
            }
            Map result = Arrays.stream(objProps).flatMap(ops -> ops.getProperties() == null ? java.util.stream.Stream.empty() : Arrays.stream(ops.getProperties())).filter(ps -> "info".equals(ps.getPath())).map(obj -> {
                TaskInfo info = (TaskInfo)obj.getValue();
                Validate.notNull((Object)info);
                info.getTask().setServerGuid(guid);
                return info;
            }).collect(Collectors.toMap(TaskInfo::getTask, Function.identity()));
            ArrayList thisInfos = new ArrayList(result.values());
            if (props.isTruncated()) {
                HashSet<ManagedObjectReference> delta = new HashSet<ManagedObjectReference>(tasks);
                if (!delta.removeAll(result.keySet())) {
                    LOGGER.warn("Sending all tasks again: {}", delta);
                }
                return this.getUpdatesFromServer(service, guid, delta).thenApply(nestedInfos -> {
                    thisInfos.addAll(nestedInfos);
                    return thisInfos;
                });
            }
            return Promises.resolve(thisInfos);
        });
    }
}

