/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.utils;

import com.vmware.srm.client.infrastructure.authorization.data.EntityPrivilege;
import com.vmware.srm.client.infrastructure.authorization.data.PrivilegeAvailability;
import com.vmware.srm.client.infrastructure.commonData.MoRefData;
import com.vmware.srm.client.infrastructure.localization.LocalizationUtil;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PrivilegeUtil {
    private static final String DOT_SEPARATOR = ".";
    private static final String PRIVILEGE_LABEL_KEY = "privilege.%s.label";
    private static final String PRIVILEGE_TEXT_SEPARATOR = " > ";

    public static Map<MoRefData, Boolean> getPrivilegesMap(List<EntityPrivilege> vmPrivileges, String privilege) {
        Map<MoRefData, Boolean> vmToPrivilegeMap = vmPrivileges.stream().collect(Collectors.toMap(entityPrivilege -> entityPrivilege.getMoRef(), entityPrivilege -> {
            PrivilegeAvailability[] privilegeAvailabilities = entityPrivilege.getPrivilegeAvailabilities();
            return privilegeAvailabilities.length == 0 || privilegeAvailabilities.length == 1 && privilegeAvailabilities[0].getPrivilegeId().equals(privilege) && privilegeAvailabilities[0].isGranted();
        }));
        return vmToPrivilegeMap;
    }

    public static String getPrivilegeText(String privilegeId) {
        String[] privilegeIdParts = privilegeId.split("\\.");
        StringBuilder resultBuffer = new StringBuilder();
        StringBuilder partsBuffer = new StringBuilder(privilegeId.length());
        for (int i = 0; i < privilegeIdParts.length; ++i) {
            if (i > 0) {
                partsBuffer.append(DOT_SEPARATOR);
            }
            partsBuffer.append(privilegeIdParts[i]);
            String privilegePart = partsBuffer.toString();
            String messageKey = String.format(PRIVILEGE_LABEL_KEY, privilegePart);
            String message = LocalizationUtil.getLocalizedMessage(messageKey);
            if (message == null || messageKey.equals(message)) continue;
            if (resultBuffer.length() > 0) {
                resultBuffer.append(PRIVILEGE_TEXT_SEPARATOR);
            }
            resultBuffer.append(message);
        }
        return resultBuffer.toString();
    }
}

