/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.websso;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.utilities.Disposable;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.impl.common.AsyncOpRetryWrapper;
import com.vmware.srm.client.topology.impl.lspp.LsppServiceImpl;
import com.vmware.srm.client.topology.impl.lspp.Types;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppNode;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppService;
import com.vmware.vim.binding.lookup.ServiceContent;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.vmomi.core.Future;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;

public class LsppQuery
implements Disposable {
    private final LsppServiceImpl _service;
    private final AsyncOpRetryWrapper<String> _getSiteId;

    public LsppQuery(URI lsppUrl, String lsppThumbprint) {
        this._service = LsppServiceImpl.create((URI)lsppUrl, (String)lsppThumbprint, (LsppServiceImpl.VmodlVersion)LsppServiceImpl.VmodlVersion.v2);
        this._getSiteId = new AsyncOpRetryWrapper(() -> this.getSiteId(this._service));
    }

    public Promise<Set<LsppService>> query(Types.LsppType type) {
        Validate.notNull((Object)type, (String)"type");
        ServiceRegistration.Filter filter = new ServiceRegistration.Filter();
        filter.setServiceType(type.getVmodlType());
        return this.query(filter, true);
    }

    public Promise<Set<LsppService>> query(ServiceRegistration.Filter filter) {
        return this.query(filter, true);
    }

    private Promise<Set<LsppService>> query(ServiceRegistration.Filter filter, boolean useLocalSiteId) {
        Validate.notNull((Object)filter, (String)"filter");
        return this._service.getContent().thenApply(ServiceContent::getServiceRegistration).thenApply(arg_0 -> ((LsppServiceImpl)this._service).createStub(arg_0)).thenCombineCompose(useLocalSiteId ? this._getSiteId.get() : Promises.resolve((Object)filter.getSiteId()), (sr, siteId) -> {
            filter.setSiteId(siteId);
            FuturePromise result = new FuturePromise();
            sr.list(filter, (Future)result);
            return result;
        }).thenApply(serviceInfos -> {
            if (ArrayUtils.isEmpty((Object[])serviceInfos)) {
                return Collections.emptySet();
            }
            LinkedHashSet<LsppService> result = new LinkedHashSet<LsppService>();
            for (ServiceRegistration.Info info : serviceInfos) {
                result.add(LsppNode.createService((ServiceRegistration.Info)info));
            }
            return result;
        });
    }

    public void dispose() {
        this._service.dispose();
    }

    private Promise<String> getSiteId(LsppServiceImpl service) {
        return service.getContent().thenApply(ServiceContent::getServiceRegistration).thenApply(arg_0 -> ((LsppServiceImpl)service).createStub(arg_0)).thenCompose(sr -> {
            FuturePromise siteId = new FuturePromise();
            sr.getSiteId((Future)siteId);
            return siteId;
        });
    }
}

