/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.httpclient;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.apache.http.client.protocol.HttpClientContext;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;

public final class HttpClientSecuritySupport {
    private HttpClientSecuritySupport() {
    }

    public static void marshalSecurityParameters(@Nonnull HttpClientContext context, @Nullable HttpClientSecurityParameters securityParameters) {
        HttpClientSecuritySupport.marshalSecurityParameters(context, securityParameters, false);
    }

    public static void marshalSecurityParameters(@Nonnull HttpClientContext context, @Nullable HttpClientSecurityParameters securityParameters, boolean replace) {
        if (securityParameters == null) {
            return;
        }
        Constraint.isNotNull((Object)context, (String)"HttpClientContext was null");
        if (securityParameters.getCredentialsProvider() != null && (replace || context.getCredentialsProvider() == null)) {
            context.setCredentialsProvider(securityParameters.getCredentialsProvider());
        }
        HttpClientSecuritySupport.setContextValue(context, "opensaml.TrustEngine", securityParameters.getTLSTrustEngine(), replace);
        HttpClientSecuritySupport.setContextValue(context, "opensaml.CriteriaSet", securityParameters.getTLSCriteriaSet(), replace);
        HttpClientSecuritySupport.setContextValue(context, "javasupport.TLSProtocols", securityParameters.getTLSProtocols(), replace);
        HttpClientSecuritySupport.setContextValue(context, "javasupport.TLSCipherSuites", securityParameters.getTLSCipherSuites(), replace);
        HttpClientSecuritySupport.setContextValue(context, "javasupport.HostnameVerifier", securityParameters.getHostnameVerifier(), replace);
        HttpClientSecuritySupport.setContextValue(context, "opensaml.ClientTLSCredential", securityParameters.getClientTLSCredential(), replace);
    }

    public static void setContextValue(@Nonnull HttpClientContext context, @Nonnull String attributeName, @Nullable Object attributeValue, boolean replace) {
        if (attributeValue == null) {
            return;
        }
        Constraint.isNotNull((Object)context, (String)"HttpClientContext was null");
        Constraint.isNotNull((Object)attributeName, (String)"Context attribute name was null");
        if (replace || context.getAttribute(attributeName) == null) {
            context.setAttribute(attributeName, attributeValue);
        }
    }
}

