/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.core.mxn.nodes;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.utilities.HashUtils;
import com.vmware.dr.ui.tools.utilities.StringUtils;
import com.vmware.srm.client.topology.client.view.Server;
import com.vmware.srm.client.topology.client.view.certificate.CertificateValidityInfo;
import com.vmware.srm.client.topology.impl.core.engine.Node;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.BaseNode;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.NodeContext;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.utils.LsppHelper;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppService;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppServiceEndpoint;
import com.vmware.srm.client.topology.impl.sso.CertificateUtils;
import com.vmware.srm.client.topology.impl.view.ServersViewImpl;
import com.vmware.srm.client.topology.impl.vmomi.TokenProvider;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.VmomiServiceImpl;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseVmomiNode<T extends VmomiServiceImpl<?, ?>, P extends Server<?>>
extends BaseNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseVmomiNode.class);
    private static final String PUBLISHER_KEY = "BaseVmomiNode.Publisher";
    private final LsppService _serverRegistration;
    private final LsppServiceEndpoint _vmomiEp;
    private final TokenProvider _tokenProvider;
    private final boolean _local;
    private final int _hashCode;
    private volatile T _service;
    private volatile ServersViewImpl.Publisher _publisher;

    BaseVmomiNode(LsppService serverRegistration, String vmomiEpType, TokenProvider tokenProvider, boolean local, ServersViewImpl.Publisher publisher) {
        Validate.notNull((Object)serverRegistration, (String)"serviceRegistration");
        Validate.notNull((Object)tokenProvider, (String)"tokenProvider");
        LsppServiceEndpoint vmomiEp = LsppHelper.getVmomiEndpoint(serverRegistration, vmomiEpType);
        if (vmomiEp == null) {
            LOGGER.error("No vmomi endpoint in registration '{}'", (Object)serverRegistration);
            throw new IllegalArgumentException("vmomiEp");
        }
        this._vmomiEp = vmomiEp;
        this._serverRegistration = serverRegistration;
        this._tokenProvider = tokenProvider;
        this._local = local;
        this._hashCode = HashUtils.getHashCode((Object[])new Object[]{serverRegistration});
        this._publisher = publisher;
    }

    @Override
    public final int hashCode() {
        return this._hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseVmomiNode)) {
            return false;
        }
        BaseVmomiNode other = (BaseVmomiNode)obj;
        return HashUtils.areEqual((Object)this._serverRegistration, (Object)other._serverRegistration) && HashUtils.areEqual((Object)this._tokenProvider, (Object)other._tokenProvider);
    }

    @Override
    public String toString() {
        HashMap<String, Object> members = new HashMap<String, Object>();
        members.put("_local", this._local);
        members.put("_serverRegistration", this._serverRegistration);
        String instanceName = this.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this));
        return StringUtils.getToStringValue((String)instanceName, members);
    }

    @Override
    public final void added(NodeContext context) {
        NodeContext.NestedContext nodeContext = context.getNodeContext(this);
        if (nodeContext.putIfAbsent(PUBLISHER_KEY, this._publisher) == null) {
            this.added(context, nodeContext);
        } else {
            LOGGER.warn("Publisher already added for {}.", (Object)this);
            this._publisher.complete();
        }
        this._publisher = null;
    }

    protected void added(NodeContext context, NodeContext.NestedContext nodeContext) {
    }

    @Override
    public final void update(Node<NodeContext> suggested, NodeContext context) {
        BaseVmomiNode suggestedVmomi = (BaseVmomiNode)suggested;
        NodeContext.NestedContext nodeContext = context.getNodeContext(this);
        if (nodeContext.putIfAbsent(PUBLISHER_KEY, suggestedVmomi._publisher) == null) {
            LOGGER.trace("Updated 'Publisher' for '{}' from '{}'", (Object)this, (Object)suggestedVmomi);
            this.update(suggested, context, nodeContext);
        } else {
            LOGGER.error("Publisher already updated for {}.", (Object)this);
            suggestedVmomi._publisher.complete();
        }
        suggestedVmomi._publisher = null;
    }

    protected void update(Node<NodeContext> suggested, NodeContext context, NodeContext.NestedContext nodeContext) {
    }

    @Override
    public void removed() {
        this.dispose();
    }

    @Override
    public void dispose() {
        T service = this._service;
        this._service = null;
        if (service != null) {
            ((VmomiServiceImpl)service).dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Promise<Set<? extends Node<NodeContext>>> discoverNeighbours(NodeContext context) {
        NodeContext.NestedContext nodeContext = context.getNodeContext(this);
        ServersViewImpl.Publisher publisher = (ServersViewImpl.Publisher)nodeContext.get(PUBLISHER_KEY);
        if (publisher == null) {
            LOGGER.error("No publisher for {}", (Object)this);
            return Promises.resolve(Collections.emptySet());
        }
        try {
            if (this._service == null) {
                KeyStore store;
                try {
                    store = CertificateUtils.createTrustStore(this._vmomiEp.getCertificates());
                }
                catch (IOException | GeneralSecurityException e) {
                    Promise promise = Promises.reject((Exception)e);
                    publisher.complete();
                    return promise;
                }
                this._service = this.createService(this._vmomiEp.url, store, this._tokenProvider);
            }
            P server = this.createServer(context, context.getView(), this._service, this._serverRegistration, this._vmomiEp, this.collectCertificateIssues(this._vmomiEp.getCertificates()));
            server.getStatus();
            publisher.publish((Server<?>)server);
            Promise<Set<Node<NodeContext>>> promise = this.discoverNeighbours(publisher, this._service, server);
            return promise;
        }
        finally {
            publisher.complete();
        }
    }

    private List<CertificateValidityInfo> collectCertificateIssues(Set<X509Certificate> certificates) {
        return certificates.stream().map(CertificateValidityInfo::new).filter(certInfo -> certInfo.getStatus() != CertificateValidityInfo.Status.Valid).collect(Collectors.toList());
    }

    LsppService getServerReg() {
        return this._serverRegistration;
    }

    protected T getService() {
        return this._service;
    }

    protected TokenProvider getTokenProvider() {
        return this._tokenProvider;
    }

    protected boolean isLocal() {
        return this._local;
    }

    abstract T createService(URI var1, KeyStore var2, TokenProvider var3);

    protected abstract P createServer(NodeContext var1, ServersViewImpl var2, T var3, LsppService var4, LsppServiceEndpoint var5, List<CertificateValidityInfo> var6);

    protected abstract Promise<Set<? extends Node<NodeContext>>> discoverNeighbours(ServersViewImpl.Publisher var1, T var2, P var3);

    @Override
    public void neighbourAdded(Node<NodeContext> neighbour, NodeContext context) {
    }

    @Override
    public void neighbourRemoved(Node<NodeContext> neighbour, NodeContext context) {
    }

    @Override
    public void neighbourUpdated(Node<NodeContext> neighbour, NodeContext context) {
    }
}

