/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.core.mxn.nodes;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.client.view.Server;
import com.vmware.srm.client.topology.client.view.availability.hms.HmsServer;
import com.vmware.srm.client.topology.client.vmomi.availability.hms.HmsService;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.BasePairNode;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.NodeContext;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.utils.HmsHelper;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.utils.PairSetupPublisher;
import com.vmware.srm.client.topology.impl.utils.L10N;
import com.vmware.srm.client.topology.impl.view.ServersViewImpl;
import com.vmware.srm.client.topology.impl.view.availability.PairSetupImpl;
import com.vmware.srm.client.topology.impl.view.availability.hms.HmsPairSetupImpl;
import com.vmware.srm.client.topology.impl.view.availability.hms.HmsServerImpl;
import com.vmware.srm.client.topology.impl.vmomi.TokenProvider;
import com.vmware.srm.client.topology.impl.vmomi.version.VersionUtils;
import com.vmware.vim.binding.hms.ServiceInstanceContent;
import com.vmware.vim.binding.hms.SessionManager;
import com.vmware.vim.binding.hms.fault.AlreadyLoggedIn;
import com.vmware.vim.binding.hms.version.version18;
import com.vmware.vim.binding.vim.fault.NotAuthenticated;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HmsPairNode
extends BasePairNode<HmsServerImpl, HmsPairSetupImpl, HmsHelper.PairInfo> {
    HmsPairNode(HmsServerImpl hms, HmsHelper.PairInfo info, PairSetupPublisher<HmsPairSetupImpl> publisher) {
        super(info.lsppUrl, info.lsppThumbprint, hms.guid(), info.hmsUuid, hms, info, publisher);
    }

    @Override
    protected HmsPairSetupImpl createPairSetup(NodeContext context, ServersViewImpl view, HmsServerImpl server, HmsHelper.PairInfo info) {
        HmsPairSetupImpl ps = new HmsPairSetupImpl(view, server, info.lsppUrl, info.lsppThumbprint, info.name, info.hmsUuid, info.vcGuid, info.vcName, info.remoteServerVmomiRef);
        context.getRecorder().recordHmsPair(ps);
        return ps;
    }

    @Override
    protected PairSetupImpl.RemoteLoginSupplier getRemoteLoginSupplier(HmsPairSetupImpl ps, TokenProvider tp) {
        return new LoginRemoteSiteTask(ps, tp);
    }

    private static class LoginRemoteSiteTask
    implements PairSetupImpl.RemoteLoginSupplier {
        private final HmsPairSetupImpl _pairSetup;
        private final TokenProvider _provider;
        private static final Logger LOGGER = LoggerFactory.getLogger(HmsPairNode.class);

        LoginRemoteSiteTask(HmsPairSetupImpl pairSetup, TokenProvider provider) {
            this._pairSetup = pairSetup;
            this._provider = provider;
        }

        @Override
        public Promise<Void> get() {
            HmsService service = (HmsService)((HmsServer)this._pairSetup.server()).service();
            return service.getContent().thenCompose(content -> {
                SessionManager sm = (SessionManager)service.createStub(content.getSessionManager());
                FuturePromise checkSessionPromise = new FuturePromise();
                sm.checkCurrentSessionHealth((Future)checkSessionPromise);
                return checkSessionPromise.thenCompose(unused -> {
                    FuturePromise getSessionPromise = new FuturePromise();
                    sm.getCurrentSession((Future)getSessionPromise);
                    return getSessionPromise.thenCompose(currentSession -> {
                        if (currentSession == null) {
                            return Promises.reject((Exception)new NotAuthenticated());
                        }
                        ManagedObjectReference hmsServer = this._pairSetup.pairServerVmomiRef();
                        ManagedObjectReference[] hmsServers = currentSession.getHmsServers();
                        if (hmsServers != null) {
                            for (ManagedObjectReference hms : hmsServers) {
                                if (!hmsServer.getValue().equals(hms.getValue())) continue;
                                LOGGER.info("Already logged in site '{}'", (Object)hmsServer);
                                return Promises.resolve(null);
                            }
                        }
                        Promise remoteTokenPromise = this._pairSetup.getPairServer().thenApply(Server::service).thenCompose(this::getLoginToken);
                        return remoteTokenPromise.thenCompose(remoteToken -> {
                            FuturePromise result = new FuturePromise();
                            sm.loginHmsServerByToken(this._pairSetup.pairServerVmomiRef(), remoteToken.toXml(), L10N.getLocaleId(), (Future)result);
                            return result.materialize().thenCompose(pr -> {
                                if (pr.isSuccessful()) {
                                    return Promises.resolve(null);
                                }
                                Exception cause = pr.getError();
                                if (cause instanceof AlreadyLoggedIn) {
                                    return Promises.resolve(null);
                                }
                                return Promises.reject((Exception)cause);
                            });
                        });
                    });
                });
            });
        }

        private Promise<SamlToken> getLoginToken(HmsService remoteService) {
            Promise isVmodl18CompatPromise = remoteService.getVersion().thenApply(remoteHmsVersion -> {
                VmodlVersion vmodl18Version = VersionUtils.getHmsVmodlVersion(version18.class);
                return VersionUtils.isCompatible(remoteHmsVersion, vmodl18Version);
            });
            return isVmodl18CompatPromise.thenCompose(is18Compat -> {
                if (!is18Compat.booleanValue()) {
                    LOGGER.info("HMS '{}' is not vmodl18 compatible.", (Object)remoteService);
                    return this.getDelegatedToken(remoteService);
                }
                return this._provider.acquireBearerToken();
            });
        }

        private Promise<SamlToken> getDelegatedToken(HmsService remoteService) {
            return remoteService.getContent().thenApply(ServiceInstanceContent::getSolutionUsername).thenCompose(this._provider::acquireDelegatedToken);
        }
    }
}

