/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.core.mxn.nodes;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.utilities.Disposable;
import com.vmware.dr.ui.tools.utilities.RotationManager;
import com.vmware.srm.client.topology.impl.core.engine.Node;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.BaseLsppNode;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.NodeContext;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.TokenProviderImpl;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.VcNode;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.utils.LsppHelper;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppService;
import com.vmware.srm.client.topology.impl.sso.DrSecurityTokenService;
import com.vmware.srm.client.topology.impl.sso.FederationStsProxy;
import com.vmware.srm.client.topology.impl.sso.LsppRotationManagerProvider;
import com.vmware.srm.client.topology.impl.sso.SsoFacade;
import com.vmware.srm.client.topology.impl.sso.SsoUtils;
import com.vmware.srm.client.topology.impl.sso.TokenManager;
import com.vmware.srm.client.topology.impl.sso.external.ExternalTokenClient;
import com.vmware.srm.client.topology.impl.sso.external.ExternalTokenData;
import com.vmware.srm.client.topology.impl.view.ServersViewImpl;
import com.vmware.srm.client.topology.impl.vmomi.TokenProvider;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.VlsiClientUtils;
import com.vmware.vapi.cis.authn.SecurityContextFactory;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.vmomi.core.Stub;
import java.net.URI;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;

public class RemoteLsppNode
extends BaseLsppNode
implements LsppRotationManagerProvider {
    private final AggregateTokenProvider _providerImpl = new AggregateTokenProvider();

    RemoteLsppNode(Set<LsppService> lsppSsos) {
        super(lsppSsos);
    }

    @Override
    protected Set<Node<NodeContext>> getNeighbours(List<LsppHelper.DrSite> sites, ServersViewImpl view, TokenProvider tokenProvider) {
        HashSet<Node<NodeContext>> result = new HashSet<Node<NodeContext>>();
        for (LsppHelper.DrSite site : sites) {
            VcNode vcNode = new VcNode(site, view.createPublisher(), this.getTokenProvider(), false);
            result.add(vcNode);
        }
        return result;
    }

    @Override
    TokenProvider getTokenProvider() {
        return this._providerImpl;
    }

    @Override
    public void dispose() {
        this._providerImpl.dispose();
    }

    private URI getRemotePscUrl() {
        RotationManager<LsppService> manager = this.getManager();
        LsppService start = (LsppService)manager.getCurrentStart();
        return SsoUtils.getAdminEndpoint((LsppService)start).url;
    }

    private class AggregateTokenProvider
    implements TokenProvider,
    Disposable {
        private final AtomicBoolean _disposed = new AtomicBoolean(false);
        private final AtomicReference<TokenProvider> _delegateProviderRef = new AtomicReference<Object>(null);

        private AggregateTokenProvider() {
        }

        @Override
        public Promise<Boolean> isLoggedIn() {
            if (this._disposed.get()) {
                return Promises.reject((Exception)new IllegalStateException("disposed"));
            }
            TokenProvider delegate = this._delegateProviderRef.get();
            if (delegate == null) {
                return Promises.resolve((Object)false);
            }
            return this.wrap(delegate::isLoggedIn).onSuccess(loggedIn -> {
                if (!loggedIn.booleanValue()) {
                    this.cleanUpProvider(delegate);
                }
            }).onError(ignored -> this.cleanUpProvider(delegate));
        }

        @Override
        public Promise<SamlToken> getToken() {
            return this.invokeProvider(TokenProvider::getToken);
        }

        @Override
        public Promise<SamlToken> loginWith(String username, String password) {
            return this.setProviderAndInvoke(new InternalIDPProviderImpl(), provider -> provider.loginWith(username, password));
        }

        @Override
        public Promise<SamlToken> loginWith(SamlToken suToken, SamlToken actAsToken) {
            return this.setProviderAndInvoke(new InternalIDPProviderImpl(), provider -> provider.loginWith(suToken, actAsToken));
        }

        @Override
        public Promise<SamlToken> loginWith(X509Certificate certificate, PrivateKey key) {
            return this.setProviderAndInvoke(new InternalIDPProviderImpl(), provider -> provider.loginWith(certificate, key));
        }

        @Override
        public Promise<SamlToken> loginWith(SamlToken bearerToken, TokenProvider.RefreshData refreshData) {
            Function<String, Promise<SamlToken>> tokenCreator = tokenAsString -> RemoteLsppNode.this.execute(ssoReg -> SsoUtils.createSamlToken(tokenAsString, ssoReg));
            ExternalTokenClient client = new ExternalTokenClient(refreshData.getUrl(), refreshData.getVerifier(), refreshData.getTrustStore(), tokenCreator);
            return this.setProviderAndInvoke(new ExternalIDPProviderImpl(client), provider -> provider.loginWith(bearerToken, refreshData));
        }

        @Override
        public Promise<SamlToken> acquireDelegatedToken(String delegateTo) {
            if (this._disposed.get()) {
                return Promises.reject((Exception)new IllegalStateException("disposed"));
            }
            TokenProvider delegate = this._delegateProviderRef.get();
            if (delegate == null) {
                return Promises.reject((Exception)new TokenProvider.AuthenticationTokenNotAvailable(RemoteLsppNode.this.getRemotePscUrl()));
            }
            return this.wrap(delegate::getToken).onError(ignored -> this.cleanUpProvider(delegate)).thenCompose(ignored -> delegate.acquireDelegatedToken(delegateTo));
        }

        @Override
        public Promise<SamlToken> acquireBearerToken() {
            if (this._disposed.get()) {
                return Promises.reject((Exception)new IllegalStateException("disposed"));
            }
            TokenProvider delegate = this._delegateProviderRef.get();
            if (delegate == null) {
                return Promises.reject((Exception)new TokenProvider.AuthenticationTokenNotAvailable(RemoteLsppNode.this.getRemotePscUrl()));
            }
            return this.wrap(delegate::acquireBearerToken).onError(ignored -> this.cleanUpProvider(delegate));
        }

        @Override
        public <T extends ManagedObject> Promise<T> createLoginStub(T stub) {
            if (stub == null) {
                return Promises.reject((Exception)new IllegalArgumentException("stub"));
            }
            return this.invokeProvider(provider -> provider.createLoginStub(stub));
        }

        @Override
        public Promise<ExecutionContext.SecurityContext> createSecurityContext() {
            return this.invokeProvider(TokenProvider::createSecurityContext);
        }

        public void dispose() {
            if (this._disposed.getAndSet(true)) {
                return;
            }
            TokenProvider provider = this._delegateProviderRef.getAndSet(null);
            if (provider instanceof Disposable) {
                ((Disposable)provider).dispose();
            }
        }

        private <T> Promise<T> setProviderAndInvoke(TokenProvider provider, Function<TokenProvider, Promise<T>> providerFunc) {
            if (this._disposed.get()) {
                return Promises.reject((Exception)new IllegalStateException("disposed"));
            }
            if (!this._delegateProviderRef.compareAndSet(null, provider)) {
                return Promises.reject((Exception)new TokenManager.TokenRequestExists());
            }
            if (this._disposed.get()) {
                this.cleanUpProvider(provider);
                return Promises.reject((Exception)new IllegalStateException("disposed"));
            }
            return this.wrap(() -> (Promise)providerFunc.apply(provider)).onError(ignored -> this.cleanUpProvider(provider));
        }

        private <T> Promise<T> invokeProvider(Function<TokenProvider, Promise<T>> providerFunc) {
            if (this._disposed.get()) {
                return Promises.reject((Exception)new IllegalStateException("disposed"));
            }
            TokenProvider delegate = this._delegateProviderRef.get();
            if (delegate == null) {
                return Promises.reject((Exception)new TokenProvider.AuthenticationTokenNotAvailable(RemoteLsppNode.this.getRemotePscUrl()));
            }
            return this.wrap(() -> (Promise)providerFunc.apply(delegate)).onError(ignored -> this.cleanUpProvider(delegate));
        }

        private <T> Promise<T> wrap(Supplier<Promise<T>> invSupplier) {
            try {
                return invSupplier.get();
            }
            catch (Exception exc) {
                return Promises.reject((Exception)exc);
            }
        }

        private void cleanUpProvider(TokenProvider provider) {
            this._delegateProviderRef.compareAndSet(provider, null);
            if (provider instanceof Disposable) {
                ((Disposable)provider).dispose();
            }
        }
    }

    private class ExternalIDPProviderImpl
    implements TokenProvider,
    Disposable {
        private final ExternalTokenClient _client;

        private ExternalIDPProviderImpl(ExternalTokenClient client) {
            this._client = client;
        }

        @Override
        public Promise<Boolean> isLoggedIn() {
            return SsoFacade.getExternalTokenManager().isLoggedIn(this._client);
        }

        @Override
        public Promise<SamlToken> getToken() {
            return SsoFacade.getExternalTokenManager().getToken(this._client).thenApply(token -> {
                if (token == null) {
                    throw new TokenProvider.AuthenticationTokenNotAvailable(RemoteLsppNode.this.getRemotePscUrl());
                }
                return token;
            });
        }

        @Override
        public Promise<SamlToken> acquireBearerToken() {
            return this.getToken();
        }

        @Override
        public Promise<SamlToken> loginWith(SamlToken bearerToken, TokenProvider.RefreshData refreshData) {
            ExternalTokenData tokenData = new ExternalTokenData(bearerToken, refreshData.getGetExpiresAt(), refreshData.getRefreshToken());
            return SsoFacade.getExternalTokenManager().acquireToken(this._client, tokenData);
        }

        @Override
        public <T extends ManagedObject> Promise<T> createLoginStub(T stub) {
            return this.getToken().thenApply(token -> {
                VlsiClientUtils.setAuthenticationData((Stub)stub, token, null);
                return stub;
            });
        }

        @Override
        public Promise<ExecutionContext.SecurityContext> createSecurityContext() {
            return this.getToken().thenApply(token -> SecurityContextFactory.createSamlSecurityContext((SamlToken)token, null));
        }

        public void dispose() {
            SsoFacade.getExternalTokenManager().releaseToken(this._client);
        }
    }

    private class InternalIDPProviderImpl
    extends TokenProviderImpl {
        InternalIDPProviderImpl() {
            this.setSts(FederationStsProxy.create(RemoteLsppNode.this));
        }

        @Override
        public Promise<SamlToken> loginWith(X509Certificate certificate, PrivateKey key) {
            DrSecurityTokenService sts = FederationStsProxy.create(RemoteLsppNode.this, certificate, key);
            this.setSts(sts);
            return super.loginWith(certificate, key);
        }
    }
}

