/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.core.mxn.nodes.utils;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.utilities.Exceptions;
import com.vmware.dr.ui.tools.utilities.StringUtils;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.client.vmomi.availability.hms.HmsService;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.HmsNode;
import com.vmware.vim.binding.hms.remote.ForeignSiteParams;
import com.vmware.vim.binding.hms.remote.HmsServer;
import com.vmware.vim.binding.hms.remote.ServerInfo;
import com.vmware.vim.binding.hms.remote.SiteManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.util.StringUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HmsHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(HmsNode.class);

    public static Promise<List<PairInfo>> getPairInfos(HmsService service) {
        return service.getContent().thenCompose(content -> {
            SiteManager sm = (SiteManager)service.createStub(content.getSiteManager());
            FuturePromise result = new FuturePromise();
            sm.getHmsInfo(null, (Future)result);
            return result;
        }).thenApply(keyInfos -> {
            if (ArrayUtils.isEmpty((Object[])keyInfos)) {
                return Collections.emptyList();
            }
            ArrayList<PairInfo> result = new ArrayList<PairInfo>(((SiteManager.ServerInfoKeyedValue[])keyInfos).length);
            for (int i = 0; i < ((SiteManager.ServerInfoKeyedValue[])keyInfos).length; ++i) {
                PairInfo info;
                String vcName;
                SiteManager.ServerInfoKeyedValue kv = keyInfos[i];
                ServerInfo si = kv.getValue();
                if (!HmsServer.Info.class.isInstance(si)) continue;
                HmsServer.Info hmsInfo = (HmsServer.Info)si;
                String vcGuid = "unknownPairVcGuid";
                if (hmsInfo.getConnectionParams() instanceof ForeignSiteParams) {
                    vcGuid = ((ForeignSiteParams)hmsInfo.getConnectionParams()).getVcUuid();
                }
                if ((vcName = hmsInfo.getPairedVcSiteName()) == null) {
                    LOGGER.warn("Hms server at '{}' returned empty remote Vc name: '{}", (Object)service.getServerUrl(), (Object)hmsInfo);
                    vcName = "";
                }
                try {
                    info = new PairInfo(hmsInfo.getConnectionParams().getUri(), hmsInfo.getConnectionParams().getThumbprint(), hmsInfo.getUuid(), hmsInfo.getName(), vcGuid, vcName, kv.getKey());
                }
                catch (URISyntaxException e) {
                    throw Exceptions.getRuntimeException((Throwable)e);
                }
                result.add(info);
            }
            return result;
        });
    }

    public static final class PairInfo {
        public final URI lsppUrl;
        public final String lsppThumbprint;
        public final String hmsUuid;
        public final String name;
        public final String vcGuid;
        public final String vcName;
        public final ManagedObjectReference remoteServerVmomiRef;

        PairInfo(String lsppUrl, String lsppThumbprint, String hmsUuid, String name, String vcGuid, String vcName, ManagedObjectReference remoteServerVmomiRef) throws URISyntaxException {
            this.lsppUrl = new URI(lsppUrl);
            this.lsppThumbprint = lsppThumbprint;
            this.hmsUuid = hmsUuid;
            this.name = name;
            this.vcGuid = vcGuid;
            this.vcName = vcName;
            this.remoteServerVmomiRef = remoteServerVmomiRef;
        }

        public String toString() {
            return "PairInfo {" + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"lsppUrl = ", (Object)this.lsppUrl)), (boolean)false) + "," + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"lsppThumbprint = ", (Object)this.lsppThumbprint)), (boolean)false) + "," + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"hmsUuid = ", (Object)this.hmsUuid)), (boolean)false) + "," + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"name = ", (Object)this.name)), (boolean)false) + "," + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"vcGuid = ", (Object)this.vcGuid)), (boolean)false) + "," + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"vcName = ", (Object)this.vcName)), (boolean)false) + "," + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"remoteServerVmomiRef = ", (Object)this.remoteServerVmomiRef)), (boolean)false) + "\n}";
        }
    }
}

