/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.sso.external.jwt;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.vmware.srm.client.topology.impl.sso.SsoUtils;
import java.security.KeyPair;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Date;
import java.util.Objects;

public class JwtUtils {
    public static final String EXP_CLAIM = "dr_refresh_exp";
    public static final String REFRESH_TOKEN_CLAIM = "dr_refresh_token";

    public static String createJwtToken(String refreshToken, Date expDate) {
        return JwtUtils.createJwtToken(refreshToken, expDate, SsoUtils.KEY_PAIR);
    }

    public static String createJwtToken(String refreshToken, Date expDate, KeyPair keyPair) {
        Algorithm algorithm = Algorithm.RSA256((RSAPublicKey)((RSAPublicKey)keyPair.getPublic()), (RSAPrivateKey)((RSAPrivateKey)keyPair.getPrivate()));
        return JWT.create().withClaim(EXP_CLAIM, expDate).withClaim(REFRESH_TOKEN_CLAIM, refreshToken).sign(algorithm);
    }

    public static Date getExpClaim(String jwtToken) {
        return Objects.requireNonNull(JWT.decode((String)jwtToken).getClaim(EXP_CLAIM).asDate(), "Invalid refresh token");
    }

    public static String verifySignature(String token) {
        return JwtUtils.verifySignature(token, SsoUtils.KEY_PAIR);
    }

    public static String verifySignature(String token, KeyPair keyPair) {
        Algorithm algorithm = Algorithm.RSA256((RSAPublicKey)((RSAPublicKey)keyPair.getPublic()), (RSAPrivateKey)((RSAPrivateKey)keyPair.getPrivate()));
        JWTVerifier verifier = JWT.require((Algorithm)algorithm).build();
        DecodedJWT jwt = verifier.verify(token);
        Date expDate = Objects.requireNonNull(jwt.getClaim(EXP_CLAIM).asDate(), "Invalid refresh token");
        if (expDate.before(new Date())) {
            throw new IllegalArgumentException("Expired refresh token");
        }
        return Objects.requireNonNull(jwt.getClaim(REFRESH_TOKEN_CLAIM).asString(), "Invalid refresh token");
    }
}

