/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding;

import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

public class BindingDescriptor
extends AbstractIdentifiableInitializableComponent
implements Predicate<ProfileRequestContext> {
    @Nonnull
    private Predicate<ProfileRequestContext> activationCondition = Predicates.alwaysTrue();
    private boolean synchronous = false;
    private boolean artifact = false;
    private boolean signatureCapable = false;

    public void setActivationCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.activationCondition = (Predicate)Constraint.isNotNull(condition, (String)"Activation condition predicate cannot be null");
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean flag) {
        this.synchronous = flag;
    }

    public boolean isArtifact() {
        return this.artifact;
    }

    public void setArtifact(boolean flag) {
        this.artifact = flag;
    }

    public boolean isSignatureCapable() {
        return this.signatureCapable;
    }

    public void setSignatureCapable(boolean flag) {
        this.signatureCapable = flag;
    }

    public boolean apply(@Nullable ProfileRequestContext input) {
        return this.activationCondition.apply((Object)input);
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof BindingDescriptor) {
            return this.getId().equals(((BindingDescriptor)((Object)obj)).getId());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("bindingId", (Object)this.getId()).add("synchronous", this.synchronous).add("artifact", this.artifact).add("signatureCapable", this.signatureCapable).toString();
    }
}

