/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.core;

import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.core.ApiProviderStub;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.AsyncHandleSyncAdapter;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.InterfaceDefinition;
import com.vmware.vapi.core.InterfaceIdentifier;
import com.vmware.vapi.core.MethodDefinition;
import com.vmware.vapi.core.MethodIdentifier;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.core.ProviderDefinition;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.internal.provider.introspection.ApiIntrospectionStubImpl;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vapi.provider.introspection.ApiIntrospectionStub;
import java.util.Set;

public class ApiProviderStubImpl
implements ApiProviderStub {
    private final ApiProvider provider;
    private final ApiIntrospectionStub introspection;

    public ApiProviderStubImpl(ApiProvider provider) {
        Validate.notNull(provider);
        this.provider = provider;
        this.introspection = new ApiIntrospectionStubImpl(provider);
    }

    @Override
    public void getDefinition(ExecutionContext ctx, AsyncHandle<ProviderDefinition> asyncHandle) {
        this.introspection.getDefinition(ctx, asyncHandle);
    }

    @Override
    public void getInterfaceIdentifiers(ExecutionContext ctx, AsyncHandle<Set<InterfaceIdentifier>> asyncHandle) {
        this.introspection.getInterfaceIdentifiers(ctx, asyncHandle);
    }

    @Override
    public void getInterface(ExecutionContext ctx, InterfaceIdentifier iface, AsyncHandle<InterfaceDefinition> asyncHandle) {
        this.introspection.getInterface(ctx, iface, asyncHandle);
    }

    @Override
    public void getMethod(ExecutionContext ctx, MethodIdentifier method, AsyncHandle<MethodDefinition> asyncHandle) {
        this.introspection.getMethod(ctx, method, asyncHandle);
    }

    @Override
    public void invoke(String serviceId, String operationId, DataValue input, ExecutionContext ctx, AsyncHandle<MethodResult> asyncHandle) {
        this.provider.invoke(serviceId, operationId, input, ctx, asyncHandle);
    }

    @Override
    public ProviderDefinition getDefinition() {
        return this.introspection.getDefinition();
    }

    @Override
    public Set<InterfaceIdentifier> getInterfaceIdentifiers() {
        return this.introspection.getInterfaceIdentifiers();
    }

    @Override
    public InterfaceDefinition getInterface(InterfaceIdentifier iface) {
        return this.introspection.getInterface(iface);
    }

    @Override
    public MethodDefinition getMethod(MethodIdentifier method) {
        return this.introspection.getMethod(method);
    }

    @Override
    public ProviderDefinition getDefinition(ExecutionContext ctx) {
        return this.introspection.getDefinition(ctx);
    }

    @Override
    public Set<InterfaceIdentifier> getInterfaceIdentifiers(ExecutionContext ctx) {
        return this.introspection.getInterfaceIdentifiers(ctx);
    }

    @Override
    public InterfaceDefinition getInterface(ExecutionContext ctx, InterfaceIdentifier iface) {
        return this.introspection.getInterface(ctx, iface);
    }

    @Override
    public MethodDefinition getMethod(ExecutionContext ctx, MethodIdentifier method) {
        return this.introspection.getMethod(ctx, method);
    }

    @Override
    public MethodResult invoke(String serviceId, String operationId, DataValue input, ExecutionContext ctx) {
        AsyncHandleSyncAdapter<MethodResult> asyncHandle = new AsyncHandleSyncAdapter<MethodResult>();
        this.provider.invoke(serviceId, operationId, input, ctx, asyncHandle);
        return asyncHandle.get();
    }
}

