/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.bindings;

import com.vmware.vapi.bindings.type.ListType;
import com.vmware.vapi.bindings.type.OptionalType;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.MethodIdentifier;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ListValue;
import com.vmware.vapi.data.OptionalValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.util.Validate;

public final class ValidatorUtil {
    public static void validate(Type type, DataValue value, MethodIdentifier methodId) {
        block6: {
            block7: {
                block5: {
                    Validate.notNull(methodId);
                    if (!(type instanceof TypeReference)) break block5;
                    ValidatorUtil.validate(((TypeReference)type).resolve(), value, methodId);
                    break block6;
                }
                if (!(type instanceof OptionalType)) break block7;
                if (!(value instanceof OptionalValue) || !((OptionalValue)value).isSet()) break block6;
                ValidatorUtil.validate(((OptionalType)type).getElementType(), ((OptionalValue)value).getValue(), methodId);
                break block6;
            }
            if (type instanceof ListType && value instanceof ListValue) {
                ListValue listValue = (ListValue)value;
                for (DataValue dataValue : listValue) {
                    ValidatorUtil.validate(((ListType)type).getElementType(), dataValue, methodId);
                }
            } else if (type instanceof StructType && value instanceof StructValue) {
                StructType structType = (StructType)type;
                StructValue structValue = (StructValue)value;
                structType.validate(structValue, methodId);
                for (String fieldName : structType.getFieldNames()) {
                    DataValue fieldValue = structValue.hasField(fieldName) ? structValue.getField(fieldName) : null;
                    ValidatorUtil.validate(structType.getField(fieldName), fieldValue, methodId);
                }
            }
        }
    }
}

