/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.bindings.convert.impl;

import com.vmware.vapi.bindings.convert.ConverterException;
import com.vmware.vapi.bindings.type.EnumType;
import com.vmware.vapi.bindings.type.IdType;
import com.vmware.vapi.bindings.type.MapType;
import com.vmware.vapi.bindings.type.StringType;
import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.bindings.type.UriType;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.TypeConverter;
import com.vmware.vapi.internal.bindings.convert.UniTypeConverter;
import com.vmware.vapi.internal.bindings.convert.impl.ConvertUtil;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JavaUtilMapStructValueMapConverter
implements UniTypeConverter<DataValue, MapType> {
    private static final String MAP_STRUCT_NAME = "map-struct";
    private static final String UNEXPECTED_TYPE_MSG = "vapi.bindings.typeconverter.unexpected.type";
    private static final List<Class<? extends Type>> supportedKeyTypes = Arrays.asList(StringType.class, IdType.class, EnumType.class, UriType.class);
    private static final String supportedTypesNames = MessageFormat.format("{0}, {1}, {2} or {3}", StringType.class.getSimpleName(), IdType.class.getSimpleName(), EnumType.class.getSimpleName(), UriType.class.getSimpleName());

    @Override
    public Object fromValue(DataValue value, MapType declaredType, TypeConverter typeConverter) {
        return JavaUtilMapStructValueMapConverter.convertStructValueToMap(value, declaredType, typeConverter);
    }

    @Override
    public DataValue toValue(Object binding, MapType declaredType, TypeConverter typeConverter, TypeConverter.ConversionContext cc) {
        Map mapBinding = ConvertUtil.narrowType(binding, Map.class);
        JavaUtilMapStructValueMapConverter.ensureStringKeyType(declaredType.getKeyType());
        Type valueType = declaredType.getValueType();
        StructValue mapValue = new StructValue(MAP_STRUCT_NAME);
        for (Map.Entry elem : mapBinding.entrySet()) {
            String key = ConvertUtil.narrowType(elem.getKey(), String.class);
            Object value = elem.getValue();
            DataValue val = typeConverter.convertToVapi(value, valueType, cc);
            mapValue.setField(key, val);
        }
        return mapValue;
    }

    static Object convertStructValueToMap(DataValue value, MapType declaredType, TypeConverter typeConverter) {
        StructValue structValue = ConvertUtil.narrowType(value, StructValue.class);
        JavaUtilMapStructValueMapConverter.ensureStringKeyType(declaredType.getKeyType());
        Type valueType = declaredType.getValueType();
        HashMap mapBinding = new HashMap();
        for (String fieldName : structValue.getFieldNames()) {
            DataValue field = structValue.getField(fieldName);
            Object val = typeConverter.convertToJava(field, valueType);
            mapBinding.put(fieldName, val);
        }
        return mapBinding;
    }

    private static void ensureStringKeyType(Type keyType) {
        if (supportedKeyTypes.contains(keyType.getClass())) {
            return;
        }
        throw new ConverterException(UNEXPECTED_TYPE_MSG, supportedTypesNames, keyType.getClass().getSimpleName());
    }
}

