/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rest.authn;

import com.vmware.vapi.internal.protocol.client.rest.authn.FetchTokenException;
import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheBioHttpClientBuilder;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vapi.protocol.HttpConfiguration;
import java.io.Closeable;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpTokenProviderBase
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(HttpTokenProviderBase.class);
    private final String url;
    private final CloseableHttpClient client;

    public HttpTokenProviderBase(String url, HttpConfiguration httpConfig) {
        Validate.notNull(url);
        this.url = url;
        if (httpConfig == null) {
            httpConfig = new HttpConfiguration.Builder().getConfig();
        }
        this.client = new ApacheBioHttpClientBuilder().buildAndConfigure(httpConfig);
    }

    @Override
    public void close() throws IOException {
        if (this.client != null) {
            this.client.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String fetchToken(String username, String password) {
        Validate.notNull(username);
        Validate.notNull(password);
        try {
            HttpUriRequest request = this.buildTokenRequest(username, password);
            try (CloseableHttpResponse response = this.client.execute(request);){
                String accessToken = this.extractToken((HttpResponse)response);
                if (accessToken == null) {
                    throw new FetchTokenException("Received a 'null' token");
                }
                String string = accessToken;
                return string;
            }
        }
        catch (Exception e) {
            String msg = String.format("Got %s while retrieving the access token.", e.getClass().getName());
            logger.error(msg, (Throwable)e);
            throw new FetchTokenException(msg, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String fetchToken(String accessKey) {
        Validate.notNull(accessKey);
        try {
            HttpUriRequest request = this.buildTokenRequest(accessKey);
            try (CloseableHttpResponse response = this.client.execute(request);){
                String accessToken = this.extractToken((HttpResponse)response);
                if (accessToken == null) {
                    throw new FetchTokenException("Received a 'null' token");
                }
                String string = accessToken;
                return string;
            }
        }
        catch (Exception e) {
            String msg = String.format("Got %s while executing session create request.", e.getClass().getName());
            logger.error(msg, (Throwable)e);
            throw new FetchTokenException(msg, e);
        }
    }

    protected String getUrl() {
        return this.url;
    }

    protected abstract HttpUriRequest buildTokenRequest(String var1, String var2) throws Exception;

    protected abstract HttpUriRequest buildTokenRequest(String var1) throws Exception;

    protected abstract String extractToken(HttpResponse var1) throws Exception;
}

