/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rest.authn;

import com.vmware.vapi.internal.protocol.client.rest.authn.HttpTokenProviderBase;
import com.vmware.vapi.protocol.HttpConfiguration;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OauthTokenProvider
extends HttpTokenProviderBase {
    private static final Logger logger = LoggerFactory.getLogger(OauthTokenProvider.class);

    public OauthTokenProvider(String url, HttpConfiguration httpConfig) {
        super(url, httpConfig);
    }

    @Override
    protected HttpUriRequest buildTokenRequest(String username, String password) {
        logger.debug("Getting oaut token.");
        HttpPost request = new HttpPost(this.getUrl());
        String authn = String.format("%s:%s", username, new String(password));
        String authnBase64encoded = Base64.encodeBase64String((byte[])authn.getBytes(StandardCharsets.UTF_8));
        BasicHeader header = new BasicHeader("Authorization", String.format("Basic %s", authnBase64encoded));
        request.addHeader((Header)header);
        header = new BasicHeader("Accept", "application/json;version=5.7");
        request.addHeader((Header)header);
        return request;
    }

    @Override
    protected String extractToken(HttpResponse response) {
        Header[] headers = response.getHeaders("vchs-authorization");
        if (headers != null) {
            for (Header header : headers) {
                for (HeaderElement headerElement : header.getElements()) {
                    if (headerElement.getName() == null) continue;
                    return headerElement.getName();
                }
            }
        }
        return null;
    }

    @Override
    protected HttpUriRequest buildTokenRequest(String accessKey) throws Exception {
        throw new UnsupportedOperationException("This method has no implementation.");
    }
}

