/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.provider.introspection;

import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.DecoratorApiProvider;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.InterfaceDefinition;
import com.vmware.vapi.core.InterfaceIdentifier;
import com.vmware.vapi.core.MethodDefinition;
import com.vmware.vapi.core.MethodIdentifier;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.core.ProviderDefinition;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorDefinition;
import com.vmware.vapi.internal.provider.introspection.OperationIntrospectionService;
import com.vmware.vapi.internal.provider.introspection.ProviderIntrospectionService;
import com.vmware.vapi.internal.provider.introspection.ServiceIntrospectionService;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vapi.internal.util.async.FilterAsyncHandle;
import com.vmware.vapi.provider.ApiInterface;
import com.vmware.vapi.provider.introspection.ApiIntrospection;
import com.vmware.vapi.provider.introspection.IntrospectionConstants;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class IntrospectionFilter
extends DecoratorApiProvider {
    private final ApiInterface providerIntrospection;
    private final ApiInterface serviceIntrospection;
    private final ApiInterface operationIntrospection;

    public IntrospectionFilter(ApiProvider decoratedProvider, ApiIntrospection introspection, Set<ErrorDefinition> extraErrors) {
        super(decoratedProvider);
        Validate.notNull(introspection);
        Validate.notNull(extraErrors);
        Validate.noNullElements(extraErrors);
        AugmentedIntrospection augmented = new AugmentedIntrospection(introspection, extraErrors);
        this.providerIntrospection = new ProviderIntrospectionService(augmented);
        this.serviceIntrospection = new ServiceIntrospectionService(augmented);
        this.operationIntrospection = new OperationIntrospectionService(augmented);
    }

    @Override
    public void invoke(String serviceId, String operationId, DataValue input, ExecutionContext ctx, AsyncHandle<MethodResult> asyncHandle) {
        InterfaceIdentifier ifaceId = new InterfaceIdentifier(serviceId);
        ApiInterface introspectionService = this.getIntrospectionService(ifaceId);
        if (introspectionService != null) {
            MethodIdentifier methodId = new MethodIdentifier(ifaceId, operationId);
            introspectionService.invoke(ctx, methodId, input, asyncHandle);
        } else {
            this.decoratedProvider.invoke(serviceId, operationId, input, ctx, asyncHandle);
        }
    }

    private ApiInterface getIntrospectionService(InterfaceIdentifier ifaceId) {
        if (IntrospectionConstants.PROVIDER_INTROSPECTION_SERVICE_ID.equals(ifaceId)) {
            return this.providerIntrospection;
        }
        if (IntrospectionConstants.SERVICE_INTROSPECTION_SERVICE_ID.equals(ifaceId)) {
            return this.serviceIntrospection;
        }
        if (IntrospectionConstants.OPERATION_INTROSPECTION_SERVICE_ID.equals(ifaceId)) {
            return this.operationIntrospection;
        }
        return null;
    }

    private class AugmentedIntrospection
    implements ApiIntrospection {
        private final ApiIntrospection introspection;
        private final Set<ErrorDefinition> extraErrors;

        public AugmentedIntrospection(ApiIntrospection introspection, Set<ErrorDefinition> extraErrors) {
            this.introspection = introspection;
            this.extraErrors = Collections.unmodifiableSet(new HashSet<ErrorDefinition>(extraErrors));
        }

        @Override
        public void getDefinition(ExecutionContext ctx, AsyncHandle<ProviderDefinition> asyncHandle) {
            this.introspection.getDefinition(ctx, asyncHandle);
        }

        @Override
        public void getInterfaceIdentifiers(ExecutionContext ctx, AsyncHandle<Set<InterfaceIdentifier>> asyncHandle) {
            FilterAsyncHandle<Set<InterfaceIdentifier>> cb = new FilterAsyncHandle<Set<InterfaceIdentifier>>(asyncHandle){

                @Override
                protected Set<InterfaceIdentifier> filterResult(Set<InterfaceIdentifier> result) {
                    HashSet<InterfaceIdentifier> augmented = new HashSet<InterfaceIdentifier>(result);
                    augmented.add(IntrospectionConstants.PROVIDER_INTROSPECTION_SERVICE_ID);
                    augmented.add(IntrospectionConstants.SERVICE_INTROSPECTION_SERVICE_ID);
                    augmented.add(IntrospectionConstants.OPERATION_INTROSPECTION_SERVICE_ID);
                    return augmented;
                }
            };
            this.introspection.getInterfaceIdentifiers(ctx, (AsyncHandle<Set<InterfaceIdentifier>>)cb);
        }

        @Override
        public void getInterface(ExecutionContext ctx, InterfaceIdentifier ifaceId, AsyncHandle<InterfaceDefinition> asyncHandle) {
            ApiInterface introspectionService = IntrospectionFilter.this.getIntrospectionService(ifaceId);
            if (introspectionService != null) {
                asyncHandle.setResult(introspectionService.getDefinition());
            } else {
                this.introspection.getInterface(ctx, ifaceId, asyncHandle);
            }
        }

        @Override
        public void getMethod(ExecutionContext ctx, MethodIdentifier methodId, AsyncHandle<MethodDefinition> asyncHandle) {
            ApiInterface introspectionService = IntrospectionFilter.this.getIntrospectionService(methodId.getInterfaceIdentifier());
            if (introspectionService != null) {
                asyncHandle.setResult(this.augmentErrors(introspectionService.getMethodDefinition(methodId)));
                return;
            }
            FilterAsyncHandle<MethodDefinition> cb = new FilterAsyncHandle<MethodDefinition>(asyncHandle){

                @Override
                protected MethodDefinition filterResult(MethodDefinition result) {
                    if (result == null) {
                        return null;
                    }
                    return AugmentedIntrospection.this.augmentErrors(result);
                }
            };
            this.introspection.getMethod(ctx, methodId, (AsyncHandle<MethodDefinition>)cb);
        }

        private Set<ErrorDefinition> augmentErrors(Set<ErrorDefinition> errors) {
            HashSet<ErrorDefinition> augmented = new HashSet<ErrorDefinition>(errors);
            augmented.addAll(this.extraErrors);
            return augmented;
        }

        private MethodDefinition augmentErrors(MethodDefinition def) {
            return new MethodDefinition(def.getIdentifier(), def.getInputDefinition(), def.getOutputDefinition(), this.augmentErrors(def.getErrorDefinitions()));
        }
    }
}

