/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.provider.introspection;

import com.vmware.vapi.Message;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.ErrorValueException;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.InterfaceDefinition;
import com.vmware.vapi.core.InterfaceIdentifier;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataDefinition;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ListDefinition;
import com.vmware.vapi.data.StringDefinition;
import com.vmware.vapi.data.StructDefinition;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.provider.introspection.ApiIntrospectionMethodBase;
import com.vmware.vapi.internal.provider.introspection.IntrospectionAsyncHandle;
import com.vmware.vapi.internal.provider.introspection.IntrospectionDataFactory;
import com.vmware.vapi.internal.provider.introspection.SyncToAsyncApiIntrospectionAdapter;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vapi.provider.ApiMethodBasedApiInterface;
import com.vmware.vapi.provider.introspection.ApiIntrospection;
import com.vmware.vapi.provider.introspection.IntrospectionConstants;
import com.vmware.vapi.provider.introspection.SyncApiIntrospection;
import com.vmware.vapi.std.StandardDataFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;

public class ServiceIntrospectionService
extends ApiMethodBasedApiInterface {
    public ServiceIntrospectionService(ApiIntrospection introspection) {
        super(IntrospectionConstants.SERVICE_INTROSPECTION_SERVICE_ID);
        Validate.notNull(introspection);
        this.registerMethod(new GetApiMethod(introspection));
        this.registerMethod(new ListApiMethod(introspection));
    }

    public ServiceIntrospectionService(SyncApiIntrospection introspection) {
        this(new SyncToAsyncApiIntrospectionAdapter(introspection));
    }

    private static class ListApiMethod
    extends ApiIntrospectionMethodBase {
        private static final DataDefinition INPUT_DEF = new StructDefinition("operation-input", Collections.emptyMap());
        private static final DataDefinition OUTPUT_DEF = new ListDefinition(StringDefinition.getInstance());

        public ListApiMethod(ApiIntrospection introspection) {
            super(IntrospectionDataFactory.SERVICE_LIST_METHOD_ID, INPUT_DEF, OUTPUT_DEF, null, introspection);
        }

        @Override
        public void invoke(InvocationContext invocationContext, DataValue input, AsyncHandle<MethodResult> asyncHandle) {
            ExecutionContext executionContext = invocationContext.getExecutionContext();
            this.introspection.getInterfaceIdentifiers(executionContext, (AsyncHandle<Set<InterfaceIdentifier>>)new IntrospectionAsyncHandle<Set<InterfaceIdentifier>>(asyncHandle){

                @Override
                protected DataValue convert(Set<InterfaceIdentifier> result) {
                    return IntrospectionDataFactory.toServiceIdList(result);
                }
            });
        }
    }

    private static class GetApiMethod
    extends ApiIntrospectionMethodBase {
        private static final DataDefinition INPUT_DEF = new StructDefinition("operation-input", Collections.singletonMap("id", StringDefinition.getInstance()));
        private static final DataDefinition OUTPUT_DEF = IntrospectionDataFactory.SERVICE_INFO_DEF;

        public GetApiMethod(ApiIntrospection introspection) {
            super(IntrospectionDataFactory.SERVICE_GET_METHOD_ID, INPUT_DEF, OUTPUT_DEF, Collections.singleton(IntrospectionDataFactory.NOT_FOUND_ERROR_INFO_DEF), introspection);
        }

        @Override
        public void invoke(InvocationContext invocationContext, DataValue input, AsyncHandle<MethodResult> asyncHandle) {
            ExecutionContext executionContext = invocationContext.getExecutionContext();
            StructValue inputStruct = (StructValue)input;
            final String ifaceId = inputStruct.getString("id");
            this.introspection.getInterface(executionContext, new InterfaceIdentifier(ifaceId), (AsyncHandle<InterfaceDefinition>)new IntrospectionAsyncHandle<InterfaceDefinition>(asyncHandle){

                @Override
                protected DataValue convert(InterfaceDefinition result) {
                    if (result != null) {
                        return IntrospectionDataFactory.toServiceInfo(result);
                    }
                    Message errorMsg = MessageFactory.getMessage("vapi.introspection.service.not_found", ifaceId);
                    throw new ErrorValueException(StandardDataFactory.createErrorValueForMessages(IntrospectionDataFactory.NOT_FOUND_ERROR_INFO_DEF, Arrays.asList(errorMsg)));
                }
            });
        }
    }
}

