/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.std.introspection;

import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodDefinition;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.internal.bindings.TypeConverter;
import com.vmware.vapi.internal.bindings.TypeConverterImpl;
import com.vmware.vapi.internal.bindings.server.impl.AsyncContextImpl;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vapi.std.errors.StructDefinitions;
import com.vmware.vapi.std.introspection.OperationDefinitions;
import com.vmware.vapi.std.introspection.OperationProvider;
import com.vmware.vapi.std.introspection.OperationTypes;
import java.util.Arrays;
import java.util.Set;

public class OperationApiInterface
extends ApiInterfaceSkeleton {
    private OperationProvider impl;

    public OperationApiInterface() {
        this((Class<? extends OperationProvider>)null);
    }

    public OperationApiInterface(Class<? extends OperationProvider> implClass) {
        this(OperationApiInterface.createImplInstance(implClass, "com.vmware.vapi.std.introspection.impl.OperationImpl", OperationProvider.class));
    }

    public OperationApiInterface(OperationProvider impl) {
        this(impl, (TypeConverter)new TypeConverterImpl());
    }

    public OperationApiInterface(OperationProvider impl, TypeConverter converter) {
        super("com.vmware.vapi.std.introspection.operation", converter);
        Validate.notNull(impl);
        this.impl = impl;
        this.registerMethod(new ListApiMethod());
        this.registerMethod(new GetApiMethod());
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(OperationApiInterface.this.getIdentifier(), "get", OperationDefinitions.__getInput, OperationDefinitions.__getOutput, OperationApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                @Override
                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        @Override
        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, OperationDefinitions.__getInput, OperationApiInterface.this.getTypeConverter());
            String serviceId = (String)extr.valueForField("service_id");
            String operationId = (String)extr.valueForField("operation_id");
            OperationApiInterface.this.impl.get(serviceId, operationId, new AsyncContextImpl<OperationTypes.Info>(OperationApiInterface.this.getTypeConverter(), OperationDefinitions.__getOutput, invocationContext, asyncHandle, this));
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(OperationApiInterface.this.getIdentifier(), "list", OperationDefinitions.__listInput, OperationDefinitions.__listOutput, OperationApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                @Override
                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        @Override
        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, OperationDefinitions.__listInput, OperationApiInterface.this.getTypeConverter());
            String serviceId = (String)extr.valueForField("service_id");
            OperationApiInterface.this.impl.list(serviceId, new AsyncContextImpl<Set<String>>(OperationApiInterface.this.getTypeConverter(), OperationDefinitions.__listOutput, invocationContext, asyncHandle, this));
        }
    }
}

