/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.std.introspection;

import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodDefinition;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.internal.bindings.TypeConverter;
import com.vmware.vapi.internal.bindings.TypeConverterImpl;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vapi.std.errors.StructDefinitions;
import com.vmware.vapi.std.introspection.OperationDefinitions;
import com.vmware.vapi.std.introspection.OperationSyncProvider;
import java.util.Arrays;

public class OperationSyncApiInterface
extends ApiInterfaceSkeleton {
    private OperationSyncProvider impl;

    public OperationSyncApiInterface() {
        this((Class<? extends OperationSyncProvider>)null);
    }

    public OperationSyncApiInterface(Class<? extends OperationSyncProvider> implClass) {
        this(OperationSyncApiInterface.createImplInstance(implClass, "com.vmware.vapi.std.introspection.impl.OperationImpl", OperationSyncProvider.class));
    }

    public OperationSyncApiInterface(OperationSyncProvider impl) {
        this(impl, (TypeConverter)new TypeConverterImpl());
    }

    public OperationSyncApiInterface(OperationSyncProvider impl, TypeConverter converter) {
        super("com.vmware.vapi.std.introspection.operation", converter);
        Validate.notNull(impl);
        this.impl = impl;
        this.registerMethod(new ListApiMethod());
        this.registerMethod(new GetApiMethod());
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(OperationSyncApiInterface.this.getIdentifier(), "get", OperationDefinitions.__getInput, OperationDefinitions.__getOutput, OperationSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                @Override
                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        @Override
        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, OperationDefinitions.__getInput, OperationSyncApiInterface.this.getTypeConverter());
            String serviceId = (String)extr.valueForField("service_id");
            String operationId = (String)extr.valueForField("operation_id");
            try {
                asyncHandle.setResult(MethodResult.newResult(OperationSyncApiInterface.this.getTypeConverter().convertToVapi(OperationSyncApiInterface.this.impl.get(serviceId, operationId, invocationContext), OperationDefinitions.__getOutput, new TypeConverter.ConversionContext(invocationContext.getExecutionContext()))));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult(MethodResult.newErrorResult(this.toErrorValue(ex, invocationContext.getExecutionContext())));
            }
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(OperationSyncApiInterface.this.getIdentifier(), "list", OperationDefinitions.__listInput, OperationDefinitions.__listOutput, OperationSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                @Override
                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        @Override
        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, OperationDefinitions.__listInput, OperationSyncApiInterface.this.getTypeConverter());
            String serviceId = (String)extr.valueForField("service_id");
            try {
                asyncHandle.setResult(MethodResult.newResult(OperationSyncApiInterface.this.getTypeConverter().convertToVapi(OperationSyncApiInterface.this.impl.list(serviceId, invocationContext), OperationDefinitions.__listOutput, new TypeConverter.ConversionContext(invocationContext.getExecutionContext()))));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult(MethodResult.newErrorResult(this.toErrorValue(ex, invocationContext.getExecutionContext())));
            }
        }
    }
}

