/* **********************************************************
 * Copyright (c) 2019-2020 VMware, Inc.  All rights reserved.
 * -- VMware Confidential
 * **********************************************************/
package com.vmware.samples.drconfig;

import java.io.InputStream;
import java.io.PrintStream;
import java.util.Scanner;

/**
 * Helper class that uses the default console. Meaning if we are running
 * in an IDE (like Eclipse) it will use it's console. If not,
 * we are running in CMD then we will use CMD as default console for input.
 */
public class StandardIOHelper implements IOHelper {

   private final PrintStream _printer;
   private final Scanner _scanner;

   public StandardIOHelper(InputStream reader, PrintStream printer) {
      _scanner = new Scanner(reader);
      _printer = printer;
   }

   @Override
   public void writeln(String message) {
      _printer.println(message);
   }

   @Override
   public String readln(String message) {
      _printer.println(message);
      String input = _scanner.nextLine();
      return input;
   }

   @Override
   public String readln() {
      return this.readln("");
   }

   @Override
   public String readPass(String message) {
      return readln(message);
   }
}
