#!/bin/sh -e
# You need to set 2 env variables : JAVAHOME and VMKEYSTORE, or modify the 2
# values here

SAMPLEDIR=.

if [ "${JAVAHOME}" == "" ] ; then
    echo "JAVAHOME not defined.  Must be defined to run java apps.">&2
    exit 2
fi

if [ "${VMKEYSTORE}" == "" ] ; then
   echo "VMKEYSTORE not defined.  Must be defined to run java apps.">&2
   exit 2
fi

PATH=${JAVAHOME}/bin:${PATH}
export PATH

LOCALCLASSPATH=${PWD}/samples.jar
LOCALCLASSPATH=${LOCALCLASSPATH}:${CLASSPATH}

pushd ../..
"${JAVAHOME}"/bin/java -cp "${LOCALCLASSPATH}" -Djavax.net.ssl.trustStore="${VMKEYSTORE}" -Xmx1024M $*
popd

echo "Done."
