@REM This batchfile generates client stubs
@REM (proxy code) from the srm WSDL and then compiles
@REM the client sample applications.
@REM
@REM To compile the client applications without re-generating the client stubs,
@REM pass the -w as an argument to the script. For example:
@REM build -w
@REM
@REM Note that this batchfile requires you to set two environment
@REM variables:
@REM   AXISHOME
@REM   JAVAHOME
@REM
@REM See the Developer's Setup Guide for more information about
@REM AXISHOME and JAVAHOME.
@REM Alternatively, you can modify the settings of
@REM these three variables in the batchfile. Be careful if you do so.
@REM


@echo off

setlocal
set SAMPLEDIR=.
set SAMPLEJARDIR=.

if NOT DEFINED AXISHOME (
   @echo AXISHOME not defined. Must be defined to build web service apps.
   goto END
)

if NOT DEFINED JAVAHOME (
   @echo JAVAHOME not defined. Must be defined to build java apps.
   goto END
)

if NOT "x%1" == "x-w" (
   set WSDLFILESRM=..\..\..\..\wsdl\srm\srm-Service.wsdl
)

:SETENV
set PATH=%JAVAHOME%\bin;%AXISHOME%\bin;%PATH%

set LOCALCLASSPATH=%CD%;%AXISHOME%\lib\axis-ant.jar;%AXISHOME%\lib\commons-logging-1.0.4.jar;%AXISHOME%\lib\saaj.jar;%AXISHOME%\lib\axis.jar;%AXISHOME%\lib\jaxrpc.jar;%AXISHOME%\lib\wsdl4j-1.5.1.jar;%AXISHOME%\lib\commons-discovery-0.2.jar;%AXISHOME%\lib\log4j-1.2.8.jar;
for %%i in ("lib\*.jar") do call lcp.bat %CD%\%%i

set LOCALCLASSPATH=%LOCALCLASSPATH%%CLASSPATH%

:DOBUILD
call clean.bat %1

cd %SAMPLEDIR%

if NOT "x%1" == "x-w" (
   IF EXIST com\vmware\srm (
      rmdir/s/q com\vmware\srm
   )
   mkdir com\vmware\srm

   @echo Generating stubs from wsdl
   java -Xms512M -Xmx1024M -Xss512k -classpath "%LOCALCLASSPATH%" org.apache.axis.wsdl.WSDL2Java -w -O-1 -p com.vmware.srm -o. %WSDLFILESRM%

   @echo Compiling stubs.
   javac -J-Xms512M -J-Xmx512M -classpath "%LOCALCLASSPATH%" com\vmware\srm\*.java

   jar cf %SAMPLEJARDIR%\srm.jar com\vmware\srm\*.class
   @echo Done compiling stubs.
)

@echo Compiling sample utilities
javac -classpath "%LOCALCLASSPATH%" com\vmware\samples\srm\*.java
jar cf %SAMPLEJARDIR%\apputils.jar com\vmware\samples\srm\*.class

@echo Done compiling apputil

@echo Compiling samples
javac -classpath "%LOCALCLASSPATH%" com\vmware\samples\recovery\*.java
jar cf %SAMPLEJARDIR%\samples.jar com\vmware\samples\recovery\*.class

:END
@echo Done.
@echo on
