/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.types.impl;

import com.vmware.vim.binding.vmodl.managed;
import com.vmware.vim.binding.vmodl.versionKind;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.core.exception.InternalException;
import com.vmware.vim.vmomi.core.exception.VmodlAlreadyLoadedException;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vim.vmomi.core.types.VmodlVersionMap;
import com.vmware.vim.vmomi.core.types.impl.DataObjectTypeImpl;
import com.vmware.vim.vmomi.core.types.impl.FaultTypeImpl;
import com.vmware.vim.vmomi.core.types.impl.ManagedObjectTypeImpl;
import com.vmware.vim.vmomi.core.types.impl.VmodlArrayTypeImpl;
import com.vmware.vim.vmomi.core.types.impl.VmodlContextImpl;
import com.vmware.vim.vmomi.core.types.impl.VmodlEnumTypeImpl;
import com.vmware.vim.vmomi.core.types.impl.VmodlTypeImpl;
import com.vmware.vim.vmomi.core.types.impl.VmodlTypeMapImpl;
import com.vmware.vim.vmomi.core.util.ClassUtil;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmodlContextLoader {
    private static final Log _logger = LogFactory.getLog(VmodlContextLoader.class);
    private boolean _hideMoRef;
    private List<Class<?>> _vmodlVersionContext;
    private String _serviceName;
    private Map<versionKind.Value, List<Class<?>>> _vmodlVersionsByKind;
    private List<Primitive> _vmodlPrimitiveContext;
    private Map<String, String> _vmodlDataObjects;
    private Map<String, String> _wsdlNameContext;
    private VmodlContext _context;

    public void load(VmodlContext context, boolean lazyInit) {
        this._context = context;
        this.loadVersions();
        if (!lazyInit) {
            this.loadTypes();
        }
    }

    public void loadType(Class<?> clazz) {
        this.loadTypes(Arrays.asList(clazz), this._context.getVmodlTypeMap());
    }

    public void registerLoaderByWsdlName(Map<String, VmodlContextLoader> loaderMapping) {
        for (Map.Entry<String, String> entry : this._wsdlNameContext.entrySet()) {
            if (loaderMapping.containsKey(entry.getKey())) {
                throw new VmodlAlreadyLoadedException(String.format("Class %1$s already registered", entry.getValue()));
            }
            loaderMapping.put(entry.getKey(), this);
        }
    }

    public void registerLoaderByClass(Map<String, VmodlContextLoader> loaderMapping) {
        for (String className : this._wsdlNameContext.values()) {
            loaderMapping.put(className, this);
        }
    }

    public void registerPackageClassLoaders(Map<String, WeakReference<ClassLoader>> classLoaderByPackage) {
        ClassLoader classLoader = ClassUtil.getCurrentClassLoader();
        for (String string : this._wsdlNameContext.values()) {
            this.registerPackageClassLoader(classLoaderByPackage, classLoader, string);
        }
        for (Map.Entry entry : this._vmodlDataObjects.entrySet()) {
            this.registerPackageClassLoader(classLoaderByPackage, classLoader, (String)entry.getKey());
            this.registerPackageClassLoader(classLoaderByPackage, classLoader, (String)entry.getValue());
        }
    }

    private void registerPackageClassLoader(Map<String, WeakReference<ClassLoader>> classLoaderByPackage, ClassLoader classLoader, String className) {
        String packageName = ClassUtil.getPackageName(className);
        WeakReference<ClassLoader> classLoaderRef = classLoaderByPackage.get(packageName);
        if (classLoaderRef == null) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)String.format("Class loader for current package not registered. Registering class loader %s for package %s", classLoader, packageName));
            }
            classLoaderByPackage.put(packageName, new WeakReference<ClassLoader>(classLoader));
        } else if (classLoaderRef.get() == null) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)String.format("Class loader for current package was cleared. Registering class loader %s for package %s", classLoader, packageName));
            }
            classLoaderByPackage.put(packageName, new WeakReference<ClassLoader>(classLoader));
        } else if (_logger.isDebugEnabled() && !((ClassLoader)classLoaderRef.get()).equals(classLoader)) {
            _logger.warn((Object)String.format("Trying to register a different class loader %s for package %s", classLoader, packageName));
        }
    }

    private void loadVersions() {
        VmodlVersionMap versionMap = this._context.getVmodlVersionMap();
        for (Class<?> version : this._vmodlVersionContext) {
            if (versionMap.getVersion(version) != null) continue;
            versionMap.addVersion(version);
        }
        if (this._vmodlVersionsByKind != null) {
            versionMap.associateVersionsWithNamespace(this._serviceName, this._vmodlVersionsByKind);
        }
    }

    private void loadTypes() {
        VmodlTypeMap typeMap = this._context.getVmodlTypeMap();
        if (this._vmodlPrimitiveContext != null) {
            for (int i = 0; i < this._vmodlPrimitiveContext.size(); ++i) {
                Primitive primitive = this._vmodlPrimitiveContext.get(i);
                VmodlTypeImpl type = new VmodlTypeImpl(this._context);
                type.setClazz(primitive.getClazz());
                type.setKind(primitive.getKind());
                type.setVersion(this._context.getVmodlVersionMap().getVersion(primitive.getVersion()));
                type.setWsdlName(primitive.getWsdlName());
                type.initTypeName();
                typeMap.registerType(type);
                try {
                    Class typeField = (Class)primitive.getClazz().getField("TYPE").get(null);
                    typeMap.registerType(typeField, (VmodlType)type);
                    typeMap.registerType(Array.newInstance(typeField, 0).getClass(), (VmodlType)new VmodlArrayTypeImpl(type, typeField, this._context));
                }
                catch (NoSuchFieldException typeField) {
                }
                catch (IllegalAccessException e) {
                    throw new InternalException(String.format("Unable to load type of %1$s", primitive.getClazz()), e);
                }
                typeMap.registerType(new VmodlArrayTypeImpl(type, this._context));
            }
        }
        LinkedHashSet classesToLoad = new LinkedHashSet(this._wsdlNameContext.size());
        for (String className : this._wsdlNameContext.values()) {
            try {
                classesToLoad.add(((VmodlContextImpl)this._context).loadClass(className));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Error resolving class " + className, e);
            }
        }
        this.loadTypes(classesToLoad, typeMap);
    }

    private void loadTypes(Collection<Class<?>> classesToLoad, VmodlTypeMap typeMap) {
        for (Class<?> clazz : classesToLoad) {
            this.loadVmodlType(clazz, typeMap);
        }
        ArrayList<ManagedObjectTypeImpl> moTypes = new ArrayList<ManagedObjectTypeImpl>(classesToLoad.size());
        for (Class<?> clazz : classesToLoad) {
            if (!this.isManagedObject(clazz)) continue;
            this.loadManagedObjectType(clazz, typeMap, moTypes);
        }
        for (ManagedObjectTypeImpl moType : moTypes) {
            moType.init();
            ((VmodlTypeMapImpl)typeMap).registerOperations(moType);
        }
    }

    private void loadManagedObjectType(Class<?> clazz, VmodlTypeMap typeMap, List<ManagedObjectTypeImpl> moTypes) {
        for (Class<?> inner : clazz.getDeclaredClasses()) {
            if (!this.isManagedObject(inner) && typeMap.getVmodlType(inner) == null) {
                this.loadVmodlType(inner, typeMap);
                continue;
            }
            this.loadManagedObjectType(inner, typeMap, moTypes);
        }
        Class<?>[] baseClasses = clazz.getInterfaces();
        while (baseClasses != null && baseClasses.length == 1 && this.isManagedObject(baseClasses[0])) {
            this.loadManagedObjectType(baseClasses[0], typeMap, moTypes);
            baseClasses = baseClasses[0].getInterfaces();
        }
        if (typeMap.getVmodlType(clazz) == null) {
            ManagedObjectTypeImpl type = new ManagedObjectTypeImpl(clazz, this._context);
            typeMap.registerType(type);
            moTypes.add(type);
            typeMap.registerType(new VmodlArrayTypeImpl(type, this._context));
        }
    }

    private void loadVmodlType(Class<?> vmodl, VmodlTypeMap typeMap) {
        Class<?>[] inner;
        VmodlTypeImpl type = null;
        String vmodlDataObject = this._vmodlDataObjects.get(vmodl.getName());
        if (vmodlDataObject != null) {
            try {
                type = new DataObjectTypeImpl(vmodl, ((VmodlContextImpl)this._context).loadClass(vmodlDataObject), this._context);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Error resolving class " + vmodl.getName(), e);
            }
        } else if (this.isException(vmodl)) {
            type = new FaultTypeImpl((Class<? extends Exception>)vmodl, this._context);
        } else if (vmodl.isEnum()) {
            type = new VmodlEnumTypeImpl((Class<? extends Enum<?>>)vmodl, this._context);
        }
        if (type != null) {
            typeMap.registerType(type);
            typeMap.registerType(new VmodlArrayTypeImpl(type, this._context));
        }
        if ((inner = vmodl.getDeclaredClasses()) == null) {
            return;
        }
        for (int i = 0; i < inner.length; ++i) {
            this.loadVmodlType(inner[i], typeMap);
        }
    }

    private boolean isException(Class<?> clazz) {
        try {
            clazz.asSubclass(Exception.class);
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private boolean isManagedObject(Class<?> clazz) {
        return clazz.getAnnotation(managed.class) != null;
    }

    public void setVmodlTypeContext(List<Class<?>> type) {
        this._wsdlNameContext = new LinkedHashMap<String, String>();
        for (Class<?> clazz : type) {
            wsdlName wsdlNameAnnotation = clazz.getAnnotation(wsdlName.class);
            if (wsdlNameAnnotation != null) {
                this._wsdlNameContext.put(wsdlNameAnnotation.value(), clazz.getName());
            }
            for (Class<?> innerClass : clazz.getClasses()) {
                wsdlNameAnnotation = innerClass.getAnnotation(wsdlName.class);
                if (wsdlNameAnnotation == null) continue;
                this._wsdlNameContext.put(wsdlNameAnnotation.value(), clazz.getName());
            }
        }
    }

    public void setWsdlNameContext(Map<String, String> wsdlNameContext) {
        this._wsdlNameContext = wsdlNameContext;
    }

    public String getWsdlNameContext(String type) {
        return this._wsdlNameContext.get(type);
    }

    public void setVmodlVersionContext(List<Class<?>> versions) {
        this.setVmodlVersionContext(versions, null);
    }

    public void setVmodlVersionContext(List<Class<?>> versions, String serviceName) {
        this._vmodlVersionContext = versions;
        if (serviceName != null) {
            this._serviceName = serviceName;
            this._vmodlVersionsByKind = versions.stream().collect(Collectors.groupingBy(VmodlContextLoader::getVersionKind));
        }
    }

    private static versionKind.Value getVersionKind(Class<?> version) {
        versionKind annotation = version.getAnnotation(versionKind.class);
        if (annotation == null) {
            throw new IllegalStateException("versionKind annotation is missing from version " + version.getName());
        }
        return annotation.value();
    }

    public List<Class<?>> getVmodlVersionContext() {
        return this._vmodlVersionContext;
    }

    public void setVmodlPrimitiveContext(List<Primitive> type) {
        this._vmodlPrimitiveContext = type;
    }

    public void setVmodlDataObjects(Map<String, String> vmodlDataObjects) {
        this._vmodlDataObjects = vmodlDataObjects;
    }

    public void setHideMoRef(boolean hideMoRef) {
        this._hideMoRef = hideMoRef;
    }

    public boolean isHideMoRef() {
        return this._hideMoRef;
    }

    public static class Primitive {
        private Class<?> _class;
        private VmodlType.Kind _kind;
        private String _wsdlName;
        private Class<?> _version;

        public void setClazz(Class<?> clazz) {
            this._class = clazz;
        }

        public Class<?> getClazz() {
            return this._class;
        }

        public void setKind(VmodlType.Kind kind) {
            this._kind = kind;
        }

        public VmodlType.Kind getKind() {
            return this._kind;
        }

        public void setWsdlName(String wsdlName2) {
            this._wsdlName = wsdlName2;
        }

        public String getWsdlName() {
            return this._wsdlName;
        }

        public void setVersion(Class<?> version) {
            this._version = version;
        }

        public Class<?> getVersion() {
            return this._version;
        }
    }
}

