/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.dr.ui.tools.reactive.impl;

import com.vmware.dr.ui.tools.reactive.Publisher;
import com.vmware.dr.ui.tools.reactive.Subscriber;
import com.vmware.dr.ui.tools.reactive.Subscription;
import com.vmware.dr.ui.tools.reactive.impl.PromiseImpl;
import com.vmware.dr.ui.tools.reactive.impl.SubscriberWrapper;
import com.vmware.dr.ui.tools.reactive.impl.TransformStream;
import com.vmware.dr.ui.tools.reactive.impl.utils.Exceptions;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

class FlatMapTransformStream<U, R>
extends TransformStream<U, R> {
    private final Function<? super U, ? extends Publisher<? extends R>> _mapper;

    protected FlatMapTransformStream(Publisher<U> publisher, Function<? super U, ? extends Publisher<? extends R>> mapper) {
        super(publisher);
        this._mapper = mapper;
    }

    @Override
    public Subscription<R> subscribe(final Subscriber<? super R> subscriber) {
        final FlatMapHelper helper = new FlatMapHelper(subscriber);
        final Subscription inner = super.subscribe(helper);
        helper.addTeardown(inner::cancel);
        return new Subscription<R>(){

            @Override
            public Publisher<R> getPublisher() {
                return FlatMapTransformStream.this;
            }

            @Override
            public Subscriber<? super R> getSubscriber() {
                return subscriber;
            }

            @Override
            public void cancel() {
                helper.onComplete(true);
                inner.cancel();
            }
        };
    }

    @Override
    protected void processNext(U item, Subscriber<? super R> subscriber) {
        Subscription<? extends R> inner;
        Publisher<R> publisher;
        FlatMapHelper helper = (FlatMapHelper)subscriber;
        try {
            publisher = this._mapper.apply(item);
        }
        catch (Throwable t) {
            helper.onError(Exceptions.wrap(t));
            return;
        }
        Subscriber intermediate = helper.createSubscriber();
        try {
            inner = publisher.subscribe(intermediate);
        }
        catch (Throwable t) {
            helper.onError(Exceptions.wrap(t));
            return;
        }
        helper.addTeardown(inner::cancel);
    }

    class FlatMapHelper
    implements Subscriber<R> {
        private final Subscriber<R> _delegate;
        private final PromiseImpl<Void> _onTeardown = new PromiseImpl();
        private final AtomicInteger _refCount = new AtomicInteger(1);

        public FlatMapHelper(Subscriber<? super R> delegate) {
            this._delegate = new SubscriberWrapper(delegate);
        }

        @Override
        public void onNext(R item) {
            this._delegate.onNext(item);
        }

        @Override
        public void onComplete(boolean cancelled) {
            if (cancelled || this._refCount.decrementAndGet() == 0) {
                this._delegate.onComplete(cancelled);
                this._onTeardown.setResult(null);
            }
        }

        @Override
        public void onError(Exception err) {
            this._delegate.onError(err);
            this._onTeardown.setResult(null);
        }

        Subscriber<R> createSubscriber() {
            this._refCount.incrementAndGet();
            return this;
        }

        void addTeardown(Runnable toRun) {
            this._onTeardown.onSuccess(unused -> toRun.run());
        }
    }
}

