/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.client.view.certificate;

import com.vmware.dr.ui.tools.utilities.StringUtils;
import com.vmware.srm.client.topology.impl.utils.Exceptions;
import com.vmware.srm.client.topology.impl.utils.L10N;
import com.vmware.vim.vmomi.core.impl.SslUtil;
import com.vmware.vim.vmomi.core.util.StringUtil;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateValidityInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(CertificateValidityInfo.class);
    private static final String SHA256 = "SHA-256";
    private static final int CERT_WARN_DAYS = 14;
    private Status _status = Status.Valid;
    private Date _validFrom;
    private Date _validTo;
    private String _thumbprint;
    private RuntimeException _error;

    public CertificateValidityInfo(X509Certificate certificate) {
        this.setStatus(certificate);
    }

    public Status getStatus() {
        return this._status;
    }

    public void setStatus(X509Certificate certificate) {
        Validate.notNull((Object)certificate, (String)"certificate");
        Calendar cal = Calendar.getInstance();
        Date now = cal.getTime();
        cal.add(5, 14);
        Date checkDate = cal.getTime();
        this._validFrom = certificate.getNotBefore();
        this._validTo = certificate.getNotAfter();
        if (this._validFrom == null || this._validTo == null) {
            this._status = Status.Error;
            this._error = Exceptions.getRuntimeException(new CertificateException(L10N.localize("certificate.validity.error", new Object[0])));
        }
        try {
            this._thumbprint = this.getCertificateThumbprint(certificate);
        }
        catch (Exception ex) {
            LOGGER.warn("Error occurred when reading certificate info", (Throwable)ex);
            this._status = Status.Error;
            this._error = Exceptions.getRuntimeException(ex);
            return;
        }
        this.setStatusForDate(now);
        if (this._status == Status.Valid && checkDate.after(this._validTo)) {
            this._status = Status.AboutToExpire;
        }
    }

    public Date getValidFrom() {
        return this._validFrom;
    }

    public Date getValidTo() {
        return this._validTo;
    }

    public String getThumbprint() {
        return this._thumbprint;
    }

    public RuntimeException getError() {
        return this._error;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isBad() {
        if (this._status == Status.Valid) return false;
        if (this._status == Status.AboutToExpire) return false;
        return true;
    }

    private void setStatusForDate(Date checkDate) {
        this._status = checkDate.before(this._validFrom) ? Status.NotYetValid : (checkDate.after(this._validTo) ? Status.Expired : Status.Valid);
    }

    private String getCertificateThumbprint(X509Certificate cert) throws GeneralSecurityException {
        return SslUtil.computeCertificateThumbprint((X509Certificate)cert, (String)SHA256);
    }

    public String toString() {
        return "CertificateValidityInfo {" + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"_status = ", (Object)((Object)this._status))), (boolean)false) + "," + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"_validFrom = ", (Object)this._validFrom)), (boolean)false) + "," + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"_validTo = ", (Object)this._validTo)), (boolean)false) + "," + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"_thumbprint = ", (Object)this._thumbprint)), (boolean)false) + "," + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"_error = ", (Object)this._error)), (boolean)false) + "\n}";
    }

    public static enum Status {
        Valid,
        AboutToExpire,
        Expired,
        NotYetValid,
        Error;

    }
}

