/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.utils;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(HashUtils.class);
    private static final String HMAC_SHA_256 = "HmacSHA256";

    public static String hashSha256(String key, String secretKey) throws InvalidKeyException, NoSuchAlgorithmException {
        if (StringUtils.isEmpty((String)secretKey)) {
            LOGGER.warn("The secretKey is empty!");
            return key;
        }
        StringBuilder result = new StringBuilder();
        try {
            byte[] hash;
            Mac sha256_HMAC = Mac.getInstance(HMAC_SHA_256);
            SecretKeySpec secret_key = new SecretKeySpec(secretKey.getBytes(StandardCharsets.UTF_8), HMAC_SHA_256);
            sha256_HMAC.init(secret_key);
            for (byte b : hash = sha256_HMAC.doFinal(key.getBytes(StandardCharsets.UTF_8))) {
                result.append(String.format("%02X", b));
            }
        }
        catch (Exception e) {
            LOGGER.warn("Unable to encode key.");
            throw e;
        }
        return result.toString();
    }
}

