/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.utils;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.srm.client.infrastructure.pc.utils.PCUtil;
import com.vmware.srm.client.infrastructure.utils.L10N;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class ManagedObjectUtil {
    private static final String DATACENTER_FOLDER_VALUE = "group-d";

    public static Boolean areEqual(ManagedObjectReference object1, ManagedObjectReference object2) {
        if (object1 == null || object2 == null) {
            return false;
        }
        return object1.equals((Object)object2);
    }

    public static <T extends ManagedObject> Class<T> getType(ManagedObjectReference moRef) {
        if (moRef == null) {
            return null;
        }
        String type = moRef.getType();
        return ManagedObjectUtil.getType(type);
    }

    public static <T> Class<T> getType(String type) {
        if (StringUtils.isBlank((String)type)) {
            return null;
        }
        VmodlType vmodlType = VmodlTypeMap.Factory.getTypeMap().getVmodlType(type);
        if (vmodlType == null) {
            throw new RuntimeException("Type '" + type + "' not found.");
        }
        return vmodlType.getTypeClass();
    }

    public static boolean isOfType(ManagedObjectReference entity, Class<?> clazz) {
        Validate.notNull((Object)entity, (String)"entity");
        Validate.notNull(clazz, (String)"clazz");
        Class moClass = ManagedObjectUtil.getType(entity);
        return clazz.isAssignableFrom(moClass);
    }

    public static <T extends ManagedObjectReference> T getByValue(T[] morefs, String value) {
        Validate.notNull(morefs);
        Validate.notEmpty((String)value, (String)"moref value is not empty");
        for (T moref : morefs) {
            if (!moref.getValue().equals(value)) continue;
            return moref;
        }
        return null;
    }

    public static boolean isDatacenterFolder(ManagedObjectReference entity) {
        return ManagedObjectUtil.isOfType(entity, Folder.class) && entity.getValue().contains(DATACENTER_FOLDER_VALUE);
    }

    public static String getTypeWsdlName(Class<?> clazz) {
        VmodlType vmodlType = VmodlTypeMap.Factory.getTypeMap().getVmodlType(clazz);
        return vmodlType != null ? vmodlType.getWsdlName() : null;
    }

    public static String getLocalizedEntityType(String rawType) {
        String retVal;
        String formattedRawType = String.format("%s.text", rawType);
        switch (rawType) {
            case "ClusterComputeResource": {
                retVal = L10N.localize("Cluster.text", new Object[0]);
                break;
            }
            case "ComputeResource": {
                retVal = L10N.localize("Host.text", new Object[0]);
                break;
            }
            default: {
                retVal = L10N.localize(formattedRawType, new Object[0]);
            }
        }
        if (formattedRawType.equals(retVal)) {
            retVal = L10N.localize("entity.text", new Object[0]);
        }
        return retVal;
    }

    public static Promise<String> getName(ServersView view, ManagedObjectReference entity) {
        Promise namePromise = PCUtil.tryRetrieveProperty(view, entity, "name");
        return namePromise.thenApply(name -> {
            if (name != null) {
                return name;
            }
            return L10N.localize("nameNotFound", entity.getValue());
        });
    }
}

