/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import com.vmware.vim.vmomi.client.exception.VlsiCertificateException;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifierExt;
import com.vmware.vim.vmomi.core.exception.CertificateValidationException;
import com.vmware.vim.vmomi.core.impl.SslUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CRL;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.IOSession;

public class ThumbprintTrustManager
implements X509TrustManager {
    private static final Log LOG = LogFactory.getLog(ThumbprintTrustManager.class);
    private static final String SLOW_OPERATION = "%s appears to be slow (%.0f ms).";
    private static final int NANOS_IN_MILLI = 1000000;
    private static final int WARN_OPERATION_LIMIT_MS = 2000;
    private static final int INFO_OPERATION_LIMIT_MS = 1000;
    private static final int DEBUG_OPERATION_LIMIT_MS = 500;
    private final KeyStore _trustStore;
    private final ThumbprintVerifier _thumbprintVerifier;
    private final String _thumbprintAlgorithm;
    private final CertStore _crlCertStore;
    private final String _trustStorePerformanceMessage;
    private final String _crlCertStorePerformanceMessage;
    private X509TrustManager _lastTrustManager;
    private final ThreadLocal<ChainInfo> _tlsChainInfo;

    public ThumbprintTrustManager(KeyStore trustStore, ThumbprintVerifier verifier) {
        this(trustStore, verifier, null);
    }

    public ThumbprintTrustManager(KeyStore trustStore, ThumbprintVerifier verifier, String algorithm) {
        this(trustStore, null, verifier, algorithm);
    }

    public ThumbprintTrustManager(KeyStore trustStore, CertStore crlCertStore, ThumbprintVerifierExt verifier) {
        this(trustStore, crlCertStore, verifier, verifier == null ? null : verifier.getDigestAlgorithm());
    }

    public ThumbprintTrustManager(KeyStore trustStore, CertStore crlCertStore, ThumbprintVerifier verifier, String algorithm) {
        this._trustStore = trustStore;
        this._thumbprintAlgorithm = algorithm == null ? "SHA-1" : algorithm;
        this._crlCertStore = crlCertStore;
        this._thumbprintVerifier = verifier;
        this._tlsChainInfo = new ThreadLocal();
        this._trustStorePerformanceMessage = this._trustStore == null ? "Initialization of TrustManager with the default JRE trust-store (loading trusted certificates)" : String.format("Initialization of TrustManager with %s trust-store %h (loading trusted certificates)", this._trustStore.getType(), this._trustStore);
        String string = this._crlCertStorePerformanceMessage = this._crlCertStore == null ? null : String.format("%s cert-store %h certificate revocation check", this._crlCertStore.getType(), this._crlCertStore);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Created ThumbprintTrustManager with trust-store %h and cert-store %h", this._trustStore, this._crlCertStore));
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Dumping stack trace of the invocation:", (Throwable)new RuntimeException("VLSI ThumbprintTrustManager creation stack trace"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        String certThumbprint = null;
        ThumbprintVerifier.Result verifyResult = ThumbprintVerifier.Result.UNKNOWN;
        boolean isTrusted = false;
        try {
            this.checkForRevocation(chain);
            long startTime = System.nanoTime();
            try {
                certThumbprint = SslUtil.computeCertificateThumbprint((X509Certificate)chain[0], (String)this._thumbprintAlgorithm);
            }
            catch (Exception e) {
                LOG.debug((Object)"Failed to calculate certificate thumbprint", (Throwable)e);
                throw new CertificateException("Unable to compute server certificate thumbprint", e);
            }
            finally {
                ThumbprintTrustManager.logPerformance("Certificate thumbprint calculation", startTime);
            }
            if (this._thumbprintVerifier != null) {
                startTime = System.nanoTime();
                try {
                    verifyResult = this._thumbprintVerifier.verify(certThumbprint);
                }
                finally {
                    ThumbprintTrustManager.logPerformance("Certificate thumbprint validation", startTime);
                }
            }
            X509TrustManager trustManager = this.getDefaultTrustManager(false);
            startTime = System.nanoTime();
            try {
                trustManager.checkServerTrusted(chain, authType);
            }
            finally {
                ThumbprintTrustManager.logPerformance("Certificate validation by TrustManager", startTime);
            }
            LOG.debug((Object)"Server certificate chain is trusted");
            isTrusted = true;
            if (verifyResult == ThumbprintVerifier.Result.MISMATCH && LOG.isWarnEnabled()) {
                String trustStoreName = this._trustStore == null ? "default JRE" : "configured " + this._trustStore.getType();
                LOG.warn((Object)String.format("Server is trusted; certificate validation by the %s trustore succeeded while the thumbprint one failed", trustStoreName));
            }
            this._tlsChainInfo.set(new ChainInfo(chain, certThumbprint, verifyResult, isTrusted));
        }
        catch (Exception e) {
            try {
                LOG.debug((Object)"Server certificate chain is not trusted", (Throwable)e);
                if (verifyResult != ThumbprintVerifier.Result.MATCH) {
                    String thumbprintState = this._thumbprintVerifier == null ? "thumbprint verification is not configured" : "thumbprint doesn't match";
                    throw new VlsiCertificateException("Server certificate chain is not trusted and " + thumbprintState, chain, certThumbprint, isTrusted, e);
                }
                LOG.debug((Object)"Server certificate chain is not trusted but thumbprint matches");
                this._tlsChainInfo.set(new ChainInfo(chain, certThumbprint, verifyResult, isTrusted));
            }
            catch (Throwable throwable) {
                this._tlsChainInfo.set(new ChainInfo(chain, certThumbprint, verifyResult, isTrusted));
                throw throwable;
            }
        }
    }

    private void checkForRevocation(X509Certificate[] chain) throws CertificateException {
        if (this._crlCertStore == null) {
            return;
        }
        long startTime = System.nanoTime();
        try {
            for (X509Certificate cert : chain) {
                X509CRLSelector selector = new X509CRLSelector();
                selector.setCertificateChecking(cert);
                for (CRL cRL : this._crlCertStore.getCRLs(selector)) {
                    if (!cRL.isRevoked(cert)) continue;
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)String.format("The following server certificate is on the CRL:\n%s", cert));
                    }
                    throw new CertificateException("Server certificate is revoked");
                }
            }
        }
        catch (CertStoreException e) {
            throw new CertificateException("Failed to validate certificate against CertStore CRL", e);
        }
        finally {
            ThumbprintTrustManager.logPerformance(this._crlCertStorePerformanceMessage, startTime);
        }
    }

    private X509TrustManager getDefaultTrustManager(boolean preferCached) {
        if ((preferCached || this._trustStore == null) && this._lastTrustManager != null) {
            return this._lastTrustManager;
        }
        long startTime = System.nanoTime();
        try {
            TrustManagerFactory factory = this.createTrustManagerFactory();
            for (TrustManager trustManager : factory.getTrustManagers()) {
                if (!(trustManager instanceof X509TrustManager)) continue;
                X509TrustManager x509TrustManager = this._lastTrustManager = (X509TrustManager)trustManager;
                return x509TrustManager;
            }
            throw new IllegalStateException("Unable to find default trust manager");
        }
        finally {
            ThumbprintTrustManager.logPerformance(this._trustStorePerformanceMessage, startTime);
        }
    }

    private TrustManagerFactory createTrustManagerFactory() {
        try {
            TrustManagerFactory factory = TrustManagerFactory.getInstance("PKIX");
            factory.init(this._trustStore);
            return factory;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unable to create trust manager factory", e);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException("Unable to initialize trust manager factory", e);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.getDefaultTrustManager(false).checkClientTrusted(chain, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        X509TrustManager trustManager = this.getDefaultTrustManager(true);
        return trustManager.getAcceptedIssuers();
    }

    private String formatHost(String host) {
        if (host != null && host.startsWith("[") && host.endsWith("]")) {
            try {
                return InetAddress.getByName(host).getHostAddress();
            }
            catch (UnknownHostException e) {
                return host;
            }
        }
        return host;
    }

    private static void logPerformance(String operation, long startTime) {
        double operationTime = (double)(System.nanoTime() - startTime) / 1000000.0;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)String.format("%s took %.3f ms.", operation, operationTime));
        } else if (operationTime > 2000.0) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)String.format(SLOW_OPERATION, operation, operationTime));
            }
        } else if (operationTime > 1000.0) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)String.format(SLOW_OPERATION, operation, operationTime));
            }
        } else if (operationTime > 500.0 && LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format(SLOW_OPERATION, operation, operationTime));
        }
    }

    public class VlsiSslIoSessionStrategy
    extends SSLIOSessionStrategy {
        VlsiSslIoSessionStrategy(SSLContext sslContext, String[] supportedProtocols) {
            super(sslContext, supportedProtocols, null, STRICT_HOSTNAME_VERIFIER);
        }

        protected void verifySession(HttpHost host, IOSession iosession, SSLSession sslsession) throws SSLException {
            try {
                ChainInfo chainInfo;
                boolean assertionVerified;
                block8: {
                    Certificate[] certs = sslsession.getPeerCertificates();
                    X509Certificate x509 = (X509Certificate)certs[0];
                    assertionVerified = false;
                    chainInfo = (ChainInfo)ThumbprintTrustManager.this._tlsChainInfo.get();
                    ThumbprintTrustManager.this._tlsChainInfo.set(null);
                    try {
                        STRICT_HOSTNAME_VERIFIER.verify(ThumbprintTrustManager.this.formatHost(host.getHostName()), x509);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Server certificate assertion verified");
                        }
                        assertionVerified = true;
                    }
                    catch (SSLException e) {
                        if (null != chainInfo && chainInfo._verifyResult != ThumbprintVerifier.Result.MATCH) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Server certificate assertion not verified and thumbprint not matched for " + chainInfo));
                            }
                            throw new CertificateValidationException("Server certificate assertion not verified and thumbprint not matched", chainInfo._chain, chainInfo._thumbprint, chainInfo._isTrusted, (Throwable)e);
                        }
                        if (!LOG.isDebugEnabled()) break block8;
                        LOG.debug((Object)"Server certificate assertion not verified but thumbprint matches");
                    }
                }
                if (null != chainInfo && ThumbprintTrustManager.this._thumbprintVerifier != null) {
                    ThumbprintTrustManager.this._thumbprintVerifier.onSuccess(chainInfo._chain, chainInfo._thumbprint, chainInfo._verifyResult, chainInfo._isTrusted, assertionVerified);
                }
            }
            catch (SSLException e) {
                sslsession.invalidate();
                throw e;
            }
        }
    }

    public class HostnameVerifier
    implements X509HostnameVerifier {
        public void verify(String host, SSLSocket socket) throws IOException {
            long startTime = System.nanoTime();
            try {
                socket.startHandshake();
            }
            catch (IOException e) {
                this.handleHandshakeException(e, null, socket, startTime);
            }
            SSLSession session = socket.getSession();
            if (session == null) {
                InputStream in = socket.getInputStream();
                in.available();
                session = socket.getSession();
                if (session == null) {
                    try {
                        startTime = System.nanoTime();
                        socket.startHandshake();
                    }
                    catch (IOException e) {
                        this.handleHandshakeException(e, null, socket, startTime);
                    }
                    session = socket.getSession();
                }
            }
            Certificate[] certificates = null;
            try {
                certificates = session.getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException e) {
                this.handleHandshakeException(e, session, socket, null);
            }
            try {
                this.verify(host, (X509Certificate)certificates[0]);
            }
            catch (SSLException e) {
                session.invalidate();
                throw e;
            }
        }

        public void verify(String host, X509Certificate cert) throws SSLException {
            ChainInfo chainInfo;
            boolean assertionVerified;
            block6: {
                assertionVerified = false;
                chainInfo = (ChainInfo)ThumbprintTrustManager.this._tlsChainInfo.get();
                ThumbprintTrustManager.this._tlsChainInfo.set(null);
                try {
                    SSLConnectionSocketFactory.STRICT_HOSTNAME_VERIFIER.verify(ThumbprintTrustManager.this.formatHost(host), cert);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Server certificate assertion verified");
                    }
                    assertionVerified = true;
                }
                catch (SSLException e) {
                    if (null != chainInfo && chainInfo._verifyResult != ThumbprintVerifier.Result.MATCH) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Server certificate assertion not verified and thumbprint not matched for " + chainInfo));
                        }
                        throw new CertificateValidationException("Server certificate assertion not verified and thumbprint not matched", chainInfo._chain, chainInfo._thumbprint, chainInfo._isTrusted, (Throwable)e);
                    }
                    if (!LOG.isDebugEnabled()) break block6;
                    LOG.debug((Object)"Server certificate assertion not verified but thumbprint matches");
                }
            }
            if (null != chainInfo && ThumbprintTrustManager.this._thumbprintVerifier != null) {
                ThumbprintTrustManager.this._thumbprintVerifier.onSuccess(chainInfo._chain, chainInfo._thumbprint, chainInfo._verifyResult, chainInfo._isTrusted, assertionVerified);
            }
        }

        public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
            SSLConnectionSocketFactory.STRICT_HOSTNAME_VERIFIER.verify(ThumbprintTrustManager.this.formatHost(host), cns, subjectAlts);
        }

        public boolean verify(String host, SSLSession session) {
            try {
                Certificate[] certificates = session.getPeerCertificates();
                this.verify(host, (X509Certificate)certificates[0]);
                return true;
            }
            catch (SSLException e) {
                return false;
            }
        }

        private void handleHandshakeException(IOException e, SSLSession session, Socket socket, Long startTime) throws SSLException {
            long endTime = System.nanoTime();
            if (session != null) {
                session.invalidate();
            }
            String message = String.format("SSL handshake from %s:%s to %s:%s failed", socket.getLocalAddress(), socket.getLocalPort(), socket.getInetAddress(), socket.getPort());
            if (startTime != null) {
                message = String.format("%s in %d ms", message, (endTime - startTime) / 1000000L);
            }
            ChainInfo chainInfo = (ChainInfo)ThumbprintTrustManager.this._tlsChainInfo.get();
            this.logSslData(message, chainInfo, session);
            if (chainInfo != null) {
                ThumbprintTrustManager.this._tlsChainInfo.set(null);
                throw new CertificateValidationException(message, chainInfo._chain, chainInfo._thumbprint, chainInfo._isTrusted, (Throwable)e);
            }
            throw new SSLException(message, e);
        }

        private void logSslData(String message, ChainInfo chainInfo, SSLSession session) {
            if (LOG.isDebugEnabled()) {
                if (chainInfo != null) {
                    message = message + " for " + chainInfo;
                }
                if (session != null) {
                    message = message + String.format("\nProtocol: %s\nCiphersuite: %s\nSSL session creation date: %s\nSSL session last access: %s", session.getProtocol(), session.getCipherSuite(), new Date(session.getCreationTime()), new Date(session.getLastAccessedTime()));
                }
                LOG.debug((Object)message);
            }
        }
    }

    private static class ChainInfo {
        X509Certificate[] _chain;
        String _thumbprint;
        ThumbprintVerifier.Result _verifyResult;
        boolean _isTrusted;

        ChainInfo(X509Certificate[] chain, String thumbprint, ThumbprintVerifier.Result verifyResult, boolean isTrusted) {
            this._chain = chain;
            this._thumbprint = thumbprint;
            this._verifyResult = verifyResult;
            this._isTrusted = isTrusted;
        }

        public String toString() {
            return String.format("Certificate: %s\nThumbprint: %s\nResult: %s\nTrusted: %b", new Object[]{this._chain != null && this._chain.length > 0 ? this._chain[0] : "certificate not present", this._thumbprint, this._verifyResult, this._isTrusted});
        }
    }
}

