/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.client.impl.processors.request;

import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.SecurIDHandler;
import com.vmware.vim.sso.client.SecurityTokenServiceConfig;
import com.vmware.vim.sso.client.TokenSpec;
import com.vmware.vim.sso.client.UserCertificateHandler;
import com.vmware.vim.sso.client.impl.RequestBuilder;
import com.vmware.vim.sso.client.impl.RequestBuilderFactory;
import com.vmware.vim.sso.client.impl.processors.request.AcquireTokenByCertificateRequestBuilder;
import com.vmware.vim.sso.client.impl.processors.request.AcquireTokenByTokenRequestBuilder;
import com.vmware.vim.sso.client.impl.processors.request.AcquireTokenByUserCertRequestBuilder;
import com.vmware.vim.sso.client.impl.processors.request.AcquireTokenByUserPassRequestBuilder;
import com.vmware.vim.sso.client.impl.processors.request.ContinueAcquireTokenByGssRequestBuilder;
import com.vmware.vim.sso.client.impl.processors.request.ContinueAcquireTokenBySecurIDRequestBuilder;
import com.vmware.vim.sso.client.impl.processors.request.InitiateAcquireTokenByGssRequestBuilder;
import com.vmware.vim.sso.client.impl.processors.request.InitiateAcquireTokenBySecurIDRequestBuilder;
import com.vmware.vim.sso.client.impl.processors.request.RenewTokenRequestBuilder;
import com.vmware.vim.sso.client.impl.processors.request.ValidateTokenRequestBuilder;
import java.security.cert.X509Certificate;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;

public class DefaultRequestBuilderFactory
implements RequestBuilderFactory {
    private static final String WSSE_JAXB_PACKAGE = "org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0";
    private static final String WSSU_JAXB_PACKAGE = "org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_utility_1_0";
    private final boolean _hokConfirmation;
    private final int _requestValidityInSeconds;
    private static final JAXBContext _jaxbContext;

    public DefaultRequestBuilderFactory(SecurityTokenServiceConfig config) {
        this._hokConfirmation = config.getHolderOfKeyConfig() != null;
        this._requestValidityInSeconds = config.getRequestValidityInSeconds();
    }

    @Override
    public RequestBuilder getAcquireTokenByTokenBuilder(SamlToken token, TokenSpec tokenSpec) {
        return new AcquireTokenByTokenRequestBuilder(token, tokenSpec, this._hokConfirmation, _jaxbContext, this._requestValidityInSeconds);
    }

    @Override
    public RequestBuilder getAcquireTokenByCertificateBuilder(TokenSpec tokenSpec) {
        assert (this._hokConfirmation);
        return new AcquireTokenByCertificateRequestBuilder(tokenSpec, _jaxbContext, this._requestValidityInSeconds);
    }

    @Override
    public RequestBuilder getAcquireTokenByUserPassBuilder(String subject, String password, TokenSpec spec) {
        return new AcquireTokenByUserPassRequestBuilder(subject, password, spec, this._hokConfirmation, _jaxbContext, this._requestValidityInSeconds);
    }

    @Override
    public RequestBuilder getContinueAcquireTokenByGssBuilder(String contextId, byte[] leg) {
        return new ContinueAcquireTokenByGssRequestBuilder(contextId, leg, _jaxbContext, this._requestValidityInSeconds);
    }

    @Override
    public RequestBuilder getInitialAcquireTokenByGssBuilder(TokenSpec tokenSpec, byte[] initialLeg) {
        return new InitiateAcquireTokenByGssRequestBuilder(tokenSpec, initialLeg, this._hokConfirmation, _jaxbContext, this._requestValidityInSeconds);
    }

    @Override
    public RequestBuilder getAcquireTokenByUserCertBuilder(X509Certificate userCertificate, UserCertificateHandler userCertificateHandler, TokenSpec tokenSpec) {
        return new AcquireTokenByUserCertRequestBuilder(userCertificate, userCertificateHandler, tokenSpec, this._hokConfirmation, _jaxbContext, this._requestValidityInSeconds);
    }

    @Override
    public RequestBuilder getInitiateAcquireTokenBySecurIDBuilder(String userName, SecurIDHandler securIDHandler, TokenSpec tokenSpec) {
        return new InitiateAcquireTokenBySecurIDRequestBuilder(userName, securIDHandler, tokenSpec, this._hokConfirmation, _jaxbContext, this._requestValidityInSeconds);
    }

    @Override
    public RequestBuilder getContinueAcquireTokenBySecurIDBuilder(String userName, SecurIDHandler securIDHandler, String sessionID) {
        return new ContinueAcquireTokenBySecurIDRequestBuilder(userName, securIDHandler, sessionID, _jaxbContext, this._requestValidityInSeconds);
    }

    @Override
    public RequestBuilder getRenewTokenBuilder(SamlToken token, long tokenLifetimeSec) {
        return new RenewTokenRequestBuilder(token, tokenLifetimeSec, _jaxbContext, this._requestValidityInSeconds);
    }

    @Override
    public RequestBuilder getValidateTokenBuilder(SamlToken token) {
        return new ValidateTokenRequestBuilder(token, _jaxbContext, this._requestValidityInSeconds);
    }

    static {
        try {
            _jaxbContext = JAXBContext.newInstance((String)"org.oasis_open.docs.ws_sx.ws_trust._200802:org.oasis_open.docs.ws_sx.ws_trust._200512:org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0:org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_utility_1_0");
        }
        catch (JAXBException e) {
            throw new IllegalStateException("JAXBContext cannot be initialized", e);
        }
    }
}

