/*
 * Decompiled with CFR 0.152.
 */
package emitters.model;

import emitters.Versions;
import emitters.VmodlEmitter;
import emitters.model.DataProperty;
import emitters.model.EntityBase;
import emitters.model.ManagedProperty;
import emitters.model.Property;
import emitters.model.SourcePos;
import emitters.model.Version;
import emitters.model.VmodlApi;
import emitters.model.VmodlDecl;
import emitters.model.raw.RawObject;
import emitters.model.raw.RawVersion;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import vmodl.httpMapping;

public abstract class VmodlObject
extends EntityBase
implements Comparable<VmodlObject>,
VmodlApi {
    final String _source;
    protected final String _package;
    protected final String _namespace;
    protected final String _wsdlName;
    protected final boolean _isFault;
    protected final boolean _isUndocumented;
    protected final boolean _isDeprecated;
    protected Version _version;
    protected final boolean _isInternal;
    protected final Version _internalBefore;
    protected VmodlObject _container;
    protected VmodlObject _base;
    protected Set<VmodlObject> _descendents = new HashSet<VmodlObject>();
    protected httpMapping.Status _httpMapping;
    private final String _jsonName;
    private String _customName2;
    private List<SuperTypePair> _versionedSuperTypePairs = null;
    private List<VmodlObject> _nestedList = new ArrayList<VmodlObject>();
    protected final List<Property> _propertyList = new ArrayList<Property>();
    protected final List<Property> _propertyOverrideList = new ArrayList<Property>();
    private List<Property> _enabledPropertyList;
    private List<Property> _enabledPropertyOverrideList;
    public List<Property> _propertyListDigest;
    static final String indent = "   ";
    static final String doubleIndent = "      ";

    protected VmodlObject(RawObject rawObject, RawVersion rawVersion) {
        super(rawObject.getName(), null, rawObject.getComment(), rawObject.getDocSupplier());
        this._source = rawObject.getSource();
        this._package = rawObject.getPackage();
        this._namespace = VmodlEmitter.getNamespace(this._package);
        this._wsdlName = rawObject.getWsdlName();
        this._jsonName = rawObject.getJsonName();
        this._isFault = rawObject.isFault();
        if (this._isFault) {
            this._httpMapping = rawObject.getHttpMapping();
        }
        this._isUndocumented = rawObject.isUndocumented();
        this._isDeprecated = rawObject.isDeprecated();
        if (rawVersion != null) {
            this._version = rawVersion.getVersion();
        }
        this._isInternal = rawObject.isInternal();
        this._internalBefore = rawObject.internalBefore();
    }

    public void setContainer(VmodlObject container) {
        this._container = container;
        container._nestedList.add(this);
    }

    public void setBaseObject(VmodlObject base) {
        this._base = base;
        if (base != null) {
            this._base._descendents.add(this);
            if (!this.isInternal() && this._base.isInternal()) {
                Versions.reportVisibilityViolation("Conflicting visibility between official " + this.getVmodlName() + " and its base internal " + this._base.getVmodlName());
            }
        }
    }

    public void setNestedList(List<VmodlObject> nestedList) {
        this._nestedList = nestedList;
    }

    public void setVersion(Version version) {
        this._version = version;
    }

    public void setCustomName2(String name) {
        if (this._customName2 != null) {
            throw new RuntimeException(this.getFullClassName() + ": already aliased to " + this._customName2);
        }
        this._customName2 = name;
    }

    public void addProperty(Property property) {
        this._propertyList.add(property);
        if (property.getVersion().getKind() != Version.Kind.DISABLED && this._propertyListDigest != null) {
            this._propertyListDigest.add(property);
        }
    }

    public void addSkippedProperty(Property property) {
        if (this._propertyListDigest == null) {
            this._propertyListDigest = new ArrayList<Property>(this._propertyList);
        }
        this._propertyListDigest.add(property);
    }

    public void setupEnabledLists() {
        if (this._base != null) {
            this._base.setupEnabledLists();
        }
        if (this._enabledPropertyList == null) {
            this._enabledPropertyList = this.filterOutDisabledProperties(this._propertyList);
            this._enabledPropertyOverrideList = this.filterOutDisabledProperties(this._propertyOverrideList);
        }
    }

    private List<Property> filterOutDisabledProperties(List<Property> list2) {
        ArrayList<Property> result = new ArrayList<Property>();
        for (Property property : list2) {
            if (property.getVersion().getKind() == Version.Kind.DISABLED) continue;
            result.add(property);
        }
        return result;
    }

    public boolean addVersionedBaseObject(VmodlObject base, Version forVersion) {
        if (!base.hasProperties()) {
            return false;
        }
        if (this._versionedSuperTypePairs == null) {
            this._versionedSuperTypePairs = new ArrayList<SuperTypePair>();
        }
        this._versionedSuperTypePairs.add(new SuperTypePair(base, forVersion));
        for (Property prop : base._propertyList) {
            Property clone;
            boolean existing = false;
            for (int pi = 0; pi < this._propertyList.size(); ++pi) {
                Property existingProp = this._propertyList.get(pi);
                if (!prop.getName().equals(existingProp.getName())) continue;
                this._propertyOverrideList.add(existingProp);
                this._propertyList.remove(pi);
                existing = true;
                break;
            }
            if (existing || !Versions.isAncestor(forVersion, prop.getVersion())) continue;
            if (prop instanceof ManagedProperty) {
                clone = new ManagedProperty((ManagedProperty)prop, forVersion);
            } else if (prop instanceof DataProperty) {
                DataProperty dataProp = (DataProperty)prop;
                clone = new DataProperty(dataProp, forVersion);
            } else {
                throw new RuntimeException("Unknown property type: " + prop.getClass().getName());
            }
            this._propertyOverrideList.add(clone);
        }
        return true;
    }

    public String getSource() {
        return this._source;
    }

    public String getClassName() {
        return this.getName();
    }

    public String getPackage() {
        return this._package;
    }

    public String getNamespace() {
        return this._namespace;
    }

    @Override
    public String getVmodlName() {
        return this.getQualifiedVmodlType();
    }

    @Override
    public String getWsdlName() {
        return this._wsdlName;
    }

    public String getJsonName() {
        return this._jsonName;
    }

    public boolean isFault() {
        return this._isFault;
    }

    public httpMapping.Status getHttpMapping() {
        return this._httpMapping;
    }

    @Override
    public boolean isUndocumented() {
        return this._isUndocumented;
    }

    public boolean isDeprecated() {
        return this._isDeprecated;
    }

    @Override
    public Version getVersion() {
        return this._version;
    }

    @Override
    public boolean isInternal() {
        return this._isInternal;
    }

    @Override
    public Version getInternalBefore() {
        return this._internalBefore;
    }

    public VmodlObject getContainer() {
        return this._container;
    }

    public VmodlObject getBaseObject() {
        return this._base;
    }

    public List<VmodlObject> getBaseObjectList() {
        ArrayList<VmodlObject> list2 = new ArrayList<VmodlObject>();
        VmodlObject base = this._base;
        while (base != null) {
            list2.add(0, base);
            base = base._base;
        }
        return list2;
    }

    public Set<VmodlObject> getDescendents() {
        return this._descendents;
    }

    public Collection<VmodlObject> getNestedList() {
        return this._nestedList;
    }

    public List<String> getContainerNameList() {
        ArrayList<String> list2 = new ArrayList<String>();
        if (this._container != null) {
            list2.addAll(this._container.getContainerNameList());
            list2.add(this._container.getName());
        }
        return list2;
    }

    public String getFullClassName() {
        if (this._container == null) {
            return this.getName();
        }
        return VmodlEmitter.join(this.getContainerNameList(), ".") + "." + this.getName();
    }

    public String getCustomName2() {
        return this._customName2;
    }

    public VmodlObject getRootContainer() {
        VmodlObject cont = this;
        while (cont.getContainer() != null) {
            cont = cont.getContainer();
        }
        return cont;
    }

    public String getQualifiedVmodlType() {
        if (this._package.isEmpty()) {
            return this.getFullClassName();
        }
        return this._package + "." + this.getFullClassName();
    }

    public boolean hasProperties() {
        return !this._propertyList.isEmpty();
    }

    public int getPropertiesCount() {
        return this._propertyList.size();
    }

    public List<Property> getPropertyList() {
        return this._propertyList;
    }

    public List<Property> getFullPropertyList() {
        if (this._base == null) {
            return this._propertyList;
        }
        ArrayList<Property> properties = new ArrayList<Property>(this._base.getFullPropertyList());
        int baseSize = properties.size();
        for (Property myProp : this._propertyList) {
            boolean found = false;
            for (int i = 0; i < baseSize; ++i) {
                Property baseProp = (Property)properties.get(i);
                if (!baseProp.getName().equals(myProp.getName())) continue;
                properties.set(i, myProp);
                found = true;
                break;
            }
            if (found) continue;
            properties.add(myProp);
        }
        return properties;
    }

    public List<Property> getPropertyListWithOverrides() {
        ArrayList<Property> properties = new ArrayList<Property>(this._propertyList);
        properties.addAll(this._propertyOverrideList);
        return properties;
    }

    public List<SuperTypePair> getVersionedSuperTypes() {
        return this._versionedSuperTypePairs;
    }

    public Set<VmodlObject> getHardDependencies() {
        return this.getDependencies(true, false, false, false);
    }

    public Set<VmodlObject> getSoftDependencies() {
        return this.getDependencies(false, true, false, false);
    }

    public Set<VmodlObject> getAllDependencies() {
        return this.getDependencies(true, true, true, false);
    }

    public Set<VmodlObject> getAllAsToplevelDependencies(boolean wantFaults) {
        return this.getDependencies(true, true, wantFaults, true);
    }

    private Set<VmodlObject> getDependencies(boolean wantHard, boolean wantSoft, boolean wantFaults, boolean nestedAsToplevel) {
        if (wantFaults && !wantSoft) {
            throw new RuntimeException("Cannot get faults without soft dependencies.");
        }
        if (nestedAsToplevel && !wantHard) {
            throw new RuntimeException("Cannot get nested as toplevel without hard dependencies.");
        }
        HashSet<VmodlObject> dependSet = new HashSet<VmodlObject>();
        HashSet<VmodlObject> hardDependSet = new HashSet<VmodlObject>();
        if (wantHard && this._base != null) {
            hardDependSet.add(this._base);
        }
        for (VmodlDecl decl : this.getReferencedDecls(wantFaults)) {
            VmodlObject obj = decl.getObject();
            if (obj == null || obj == this) continue;
            if (obj._container != null) {
                hardDependSet.add(obj);
                continue;
            }
            if (decl.isEnum()) {
                hardDependSet.add(obj);
                continue;
            }
            if (!wantSoft) continue;
            dependSet.add(obj);
        }
        if (nestedAsToplevel) {
            dependSet.addAll(hardDependSet);
        } else if (wantHard) {
            for (VmodlObject obj : hardDependSet) {
                while (obj._container != null) {
                    obj = obj._container;
                }
                dependSet.add(obj);
            }
        }
        for (VmodlObject nestedObj : this._nestedList) {
            dependSet.addAll(nestedObj.getDependencies(wantHard, wantSoft, wantFaults, nestedAsToplevel));
        }
        dependSet.remove(this);
        return dependSet;
    }

    private boolean derivesFrom(VmodlObject other) {
        for (VmodlObject base = this.getBaseObject(); base != null; base = base.getBaseObject()) {
            if (base != other) continue;
            return true;
        }
        return false;
    }

    private boolean derivesFromWithNested(VmodlObject other) {
        ArrayDeque<VmodlObject> queue = new ArrayDeque<VmodlObject>();
        queue.add(other);
        while (!queue.isEmpty()) {
            VmodlObject obj = (VmodlObject)queue.remove();
            if (this.derivesFrom(obj)) {
                return true;
            }
            queue.addAll(obj.getNestedList());
        }
        return false;
    }

    private boolean usesEnumOrNested(VmodlObject other) {
        ArrayDeque<VmodlObject> queue = new ArrayDeque<VmodlObject>();
        if (other.getKind() == Kind.Enum) {
            queue.add(other);
        } else {
            queue.addAll(other.getNestedList());
        }
        while (!queue.isEmpty()) {
            VmodlObject obj = (VmodlObject)queue.remove();
            for (Property prop : this.getPropertyList()) {
                if (prop.getDecl().getObject() != obj) continue;
                return true;
            }
            queue.addAll(obj.getNestedList());
        }
        return false;
    }

    public boolean dependsOn(VmodlObject other) {
        ArrayDeque<VmodlObject> queue = new ArrayDeque<VmodlObject>();
        queue.add(this);
        while (!queue.isEmpty()) {
            VmodlObject obj = (VmodlObject)queue.remove();
            if (obj.derivesFromWithNested(other) || obj.usesEnumOrNested(other)) {
                return true;
            }
            queue.addAll(obj.getNestedList());
        }
        return false;
    }

    @Override
    public int compareTo(VmodlObject obj) {
        return this.getQualifiedVmodlType().compareTo(obj.getQualifiedVmodlType());
    }

    public void enqueueDigest() {
        this._version.enqueueDigestObject(this);
        if (this._base != null && !this._base._wsdlName.equals("DynamicData")) {
            this._version.enqueueDigestBaseObject(this._base);
        }
        List<Property> properties = this._propertyListDigest != null ? this._propertyListDigest : this._propertyList;
        for (Property property : properties) {
            property.enqueueDigest(this);
        }
        for (Property property : this._propertyOverrideList) {
            property.enqueueDigest(this);
        }
        for (VmodlObject object : this._nestedList) {
            object.enqueueDigest();
        }
    }

    public void print() {
        System.out.println();
        System.out.println("=== " + (Object)((Object)this.getKind()) + " " + this.getQualifiedVmodlType());
        System.out.print("Defined at: ");
        SourcePos sourcePos = this.getSourcePos();
        if (sourcePos != null) {
            System.out.println(sourcePos.absoluteName + " line " + sourcePos.line + " column " + sourcePos.column);
        } else {
            System.out.println("unknown");
        }
        System.out.println("Name: " + this.getName());
        System.out.println("Package: " + this._package);
        System.out.println("Namespace: " + this._namespace);
        System.out.println("Wsdl name: " + (this._wsdlName != null ? this._wsdlName : "None"));
        System.out.println("Is deprecated: " + this._isDeprecated);
        System.out.println("Is undocumented: " + this._isUndocumented);
        System.out.println("Is fault: " + this._isFault);
        System.out.println("Version: " + (this._version != null ? this._version.getVmodlName() : "None"));
        System.out.println("Is internal: " + this._isInternal);
        System.out.println("Internal before: " + (this._internalBefore != null ? this._internalBefore.getVmodlName() : "None"));
        System.out.println("Container: " + (this._container != null ? this._container.getQualifiedVmodlType() : "None"));
        System.out.println("Base: " + (this._base != null ? this._base.getQualifiedVmodlType() : "None"));
        System.out.print("Nested list:");
        for (VmodlObject nested : this._nestedList) {
            System.out.print(" " + nested.getQualifiedVmodlType());
        }
        System.out.println();
        System.out.println("Properties:");
        for (Property property : this._propertyList) {
            property.print(indent);
            System.out.println();
        }
        System.out.println("Override properties:");
        for (Property property : this._propertyOverrideList) {
            property.print(indent);
            System.out.println();
        }
        System.out.println("Enabled properties:");
        if (this._enabledPropertyList != null) {
            for (Property property : this._enabledPropertyList) {
                property.print(indent);
                System.out.println();
            }
        }
        System.out.println("Enabled override properties:");
        if (this._enabledPropertyOverrideList != null) {
            for (Property property : this._enabledPropertyOverrideList) {
                property.print(indent);
                System.out.println();
            }
        }
        System.out.println("Digest properties:");
        if (this._propertyListDigest != null) {
            for (Property property : this._propertyListDigest) {
                property.print(indent);
                System.out.println();
            }
        }
    }

    public abstract Kind getKind();

    public abstract Collection<VmodlDecl> getReferencedDecls(boolean var1);

    public static class SuperTypePair {
        public final VmodlObject object;
        public final Version version;

        SuperTypePair(VmodlObject obj, Version ver) {
            this.object = obj;
            this.version = ver;
        }
    }

    public static enum Kind {
        DataObject,
        Enum,
        ManagedObject;

    }
}

