/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.dr.ui.tools.utilities;

import com.vmware.dr.ui.tools.utilities.ContextApplierImpl;
import com.vmware.dr.ui.tools.utilities.ThreadContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import org.apache.commons.lang.Validate;

public class L10NHelper {
    private static final ResourceBundle.Control CONTROL = new BundleControl();
    private static final ThreadLocal<Locale> LOCALE = ThreadLocal.withInitial(() -> Locale.US);

    public static <T> Callable<T> withLocale(Callable<T> task, Locale locale) {
        ContextApplierImpl<Locale> ca = new ContextApplierImpl<Locale>(LOCALE, locale);
        return () -> ThreadContext.extendContext(task, ca);
    }

    public static Locale getLocale() {
        return LOCALE.get();
    }

    public static String localize(String bundle, ClassLoader loader, String key, Object ... params) {
        return L10NHelper.localize(bundle, loader, LOCALE.get(), key, params);
    }

    public static String localize(String bundle, ClassLoader loader, Locale locale, String key, Object ... params) {
        ResourceBundle rb = ResourceBundle.getBundle(bundle, locale, loader, CONTROL);
        return MessageFormat.format(rb.getString(key), params);
    }

    private static final class BundleControl
    extends ResourceBundle.Control {
        private BundleControl() {
        }

        @Override
        public List<String> getFormats(String baseName) {
            Validate.notNull((Object)baseName, (String)"baseName");
            return ResourceBundle.Control.FORMAT_PROPERTIES;
        }

        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            String bundleName = this.toBundleName(baseName, locale);
            String resourceName = this.toResourceName(bundleName, "properties");
            URL resourceURL = loader.getResource(resourceName);
            if (resourceURL == null) {
                return super.newBundle(baseName, locale, format, loader, reload);
            }
            InputStream is = resourceURL.openStream();
            try (InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);){
                PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(reader);
                return propertyResourceBundle;
            }
        }
    }
}

