/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vr.client.impex.tool;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.vr.client.impex.configurables.Configurable;
import com.vmware.vr.client.impex.configurables.inventory.IeInventoryTree;
import com.vmware.vr.client.impex.configurables.replications.IeReplicationGroup;
import com.vmware.vr.client.impex.exporters.inventory.HmsInventoryExporter;
import com.vmware.vr.client.impex.exporters.replications.ReplicationGroupsExporter;
import com.vmware.vr.client.impex.tool.HmsConfigurablesWrapper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HmsXmlExporterHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(HmsXmlExporterHelper.class);
    private final HmsConfigurablesWrapper _hmsConfigurablesWrapper;
    private final boolean _isRobo;

    public HmsXmlExporterHelper(HmsConfigurablesWrapper hmsConfigurablesWrapper, boolean isRobo) {
        this._hmsConfigurablesWrapper = hmsConfigurablesWrapper;
        this._isRobo = isRobo;
    }

    public Promise<List<IeInventoryTree>> exportInventoryForHms() {
        LOGGER.debug("VR inventory export started.");
        return new HmsInventoryExporter(this._isRobo).getConfigurables().thenApply(inventory -> {
            LOGGER.debug("VR inventory export ended.");
            this._hmsConfigurablesWrapper.setInventory((List<? extends Configurable>)inventory);
            return inventory;
        });
    }

    public Promise<List<IeReplicationGroup>> exportReplicationGroups() {
        LOGGER.debug("Replication groups export started.");
        if (this._isRobo) {
            LOGGER.info("Replication groups export in a ROBO mode.");
        }
        return new ReplicationGroupsExporter(this._isRobo).getConfigurables().thenApply(groups -> {
            LOGGER.debug("Replication groups export ended.");
            this._hmsConfigurablesWrapper.setReplicationGroups((List<? extends Configurable>)groups);
            return groups;
        });
    }
}

