/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.authentication;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.reactive.impl.Streams;
import com.vmware.srm.client.infrastructure.authentication.AuthenticationStrategy;
import com.vmware.srm.client.infrastructure.authentication.AuthenticationUtils;
import com.vmware.srm.client.infrastructure.http.BaseAsyncController;
import com.vmware.srm.client.infrastructure.init.InitFilter;
import com.vmware.srm.client.infrastructure.init.workflow.Configurator;
import com.vmware.srm.client.topology.impl.init.Config;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoginServlet.class);
    private static final String SUCCESS_REDIRECT_PARAM = "successRedirectPath";
    private static final String DR_UI_THEME_PARAM = "drTheme";
    private static final String FORCE_WEBSSO_PARAM = "forcewebsso";

    private static String getRedirectPath(HttpServletRequest request) {
        String theme = request.getParameter(DR_UI_THEME_PARAM);
        String fragment = request.getParameter(SUCCESS_REDIRECT_PARAM);
        Object redirectPath = "/dr/";
        if (StringUtils.isNotEmpty((String)theme)) {
            redirectPath = (String)redirectPath + "?drTheme=" + theme;
        }
        if (StringUtils.isNotEmpty((String)fragment) && fragment.startsWith("#")) {
            redirectPath = (String)redirectPath + fragment;
        }
        try {
            return new URI((String)redirectPath).parseServerAuthority().toString();
        }
        catch (URISyntaxException e) {
            LOGGER.warn("Failed to build redirect url for theme:'{}' and fragment: '{}'", new Object[]{theme, fragment, e});
            return "/dr/";
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (AuthenticationUtils.isAuthenticated(request)) {
            response.sendRedirect(LoginServlet.getRedirectPath(request));
            return;
        }
        LoginController lc = new LoginController(request, response, InitFilter.getConfigurator(request));
        lc.start(Config.get().getResponseTimeout());
    }

    private class LoginController
    extends BaseAsyncController {
        private final Configurator _configurator;

        LoginController(HttpServletRequest request, HttpServletResponse response, Configurator configurator) {
            super(request, response);
            this._configurator = configurator;
        }

        @Override
        protected BaseAsyncController.HttpProcessStage createPipeline() {
            return () -> this.process().toStream().flatMap(unused -> Streams.empty());
        }

        private Promise<Void> process() {
            return this.pickStrategy().thenCompose(strategy -> {
                try {
                    return strategy.startLogin(this._request, this._response, LoginServlet.getRedirectPath(this._request));
                }
                catch (Exception e) {
                    return Promises.reject((Exception)e);
                }
            });
        }

        private Promise<AuthenticationStrategy> pickStrategy() {
            if (this._request.getParameterMap().containsKey(LoginServlet.FORCE_WEBSSO_PARAM)) {
                return this._configurator.getWebSsoStrategy();
            }
            return this._configurator.getOAuth2Strategy().materialize().thenCompose(oauth2Pr -> this._configurator.getWebSsoStrategy().materialize().thenCompose(webSsoPr -> {
                AuthenticationStrategy oauth2Strategy = null;
                Exception oauth2StrategyExc = null;
                if (oauth2Pr.isSuccessful()) {
                    oauth2Strategy = (AuthenticationStrategy)oauth2Pr.getResult();
                } else {
                    oauth2StrategyExc = oauth2Pr.getError();
                    LOGGER.error("Failed to get OAuth2 strategy for '{}'", (Object)this._request.getRequestURI(), (Object)oauth2StrategyExc);
                }
                if (!webSsoPr.isSuccessful()) {
                    Exception webSsoStrategyExc = webSsoPr.getError();
                    LOGGER.error("Failed to get WebSso strategy for '{}'", (Object)this._request.getRequestURI(), (Object)webSsoStrategyExc);
                    if (oauth2StrategyExc != null) {
                        webSsoStrategyExc.addSuppressed(oauth2StrategyExc);
                    }
                    return Promises.reject((Exception)webSsoStrategyExc);
                }
                AuthenticationStrategy webSsoStrategy = (AuthenticationStrategy)webSsoPr.getResult();
                return oauth2Strategy == null ? Promises.resolve((Object)webSsoStrategy) : Promises.resolve((Object)oauth2Strategy);
            }));
        }
    }
}

