/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.authentication;

import com.vmware.srm.client.infrastructure.authentication.AuthenticationStrategy;
import com.vmware.srm.client.infrastructure.authentication.AuthenticationUtils;
import com.vmware.srm.client.infrastructure.authentication.SessionWrapper;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogoutServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogoutServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!AuthenticationUtils.isAuthenticated(request)) {
            response.sendError(401);
            return;
        }
        HttpSession session = request.getSession(false);
        String sessionIdAlias = SessionWrapper.getSessionIdAlias(session);
        if (sessionIdAlias != null) {
            LOGGER.info("Processing user logout request for session {}.", (Object)sessionIdAlias);
        }
        AuthenticationStrategy strategy = SessionWrapper.getAuthStrategy(session);
        Validate.notNull((Object)strategy, (String)"strategy");
        strategy.startLogout(request, response);
    }
}

