/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.authentication.oauth2;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.infrastructure.authentication.AuthenticationStrategy;
import com.vmware.srm.client.infrastructure.authentication.AuthenticationUtils;
import com.vmware.srm.client.infrastructure.http.HttpUtils;
import com.vmware.srm.client.infrastructure.oauth2.OAuth2Context;
import com.vmware.srm.client.infrastructure.oauth2.remotelogin.RemoteLoginRequestVerifier;
import com.vmware.srm.client.infrastructure.oauth2.remotelogin.RemoteLoginVerifiers;
import com.vmware.srm.client.infrastructure.utils.L10N;
import com.vmware.srm.client.infrastructure.websso.SsoContext;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppService;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppServiceEndpoint;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.web.util.UriComponentsBuilder;

public class OAuth2AuthenticationStrategy
implements AuthenticationStrategy {
    private static final String LOG_OFF_PATH = "/app/logout.jsp";
    private static final String CLIENT_ID_PARAM = "client_id";
    private static final String REDIRECT_URI_PARAM = "redirect_uri";
    private static final String STATE_PARAM = "state";
    private static final int MAX_REQUESTS = 1000;
    private static final Map<String, LoginRelayData> LOGIN_DATA_BY_UUID = new LinkedHashMap<String, LoginRelayData>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 1000;
        }
    };
    private final OAuth2Context _oauth2Context;
    private final SsoContext _ssoContext;
    private final RemoteLoginRequestVerifier _remoteLoginVerifier;

    public OAuth2AuthenticationStrategy(OAuth2Context oauth2Context, SsoContext ssoContext) {
        this._oauth2Context = oauth2Context;
        this._ssoContext = ssoContext;
        this._remoteLoginVerifier = RemoteLoginVerifiers.createRequestVerifier(oauth2Context.getServerRegistration(), ssoContext);
    }

    @Override
    public Promise<Void> startLogin(HttpServletRequest request, HttpServletResponse response, String redirectPath) throws IOException {
        if (AuthenticationUtils.isAuthenticated(request)) {
            String msg = L10N.localize("sessionAlreadyAuthenticated", new Object[0]);
            response.sendError(400, msg);
            return Promises.reject((Exception)new RuntimeException(msg));
        }
        response.sendRedirect(this.buildAuthCodeRequestUrl(null, redirectPath, false));
        return Promises.resolve(null);
    }

    @Override
    public Promise<Void> startRemoteLogin(HttpServletRequest request, HttpServletResponse response, String requestId, String authResponseEndpoint) throws ServletException, IOException {
        response.sendRedirect(this.buildAuthCodeRequestUrl(requestId, authResponseEndpoint, true));
        return Promises.resolve(null);
    }

    @Override
    public Promise<Void> startLogout(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpSession session = request.getSession(false);
        if (session == null) {
            response.sendError(401);
            return Promises.reject((Exception)new RuntimeException(L10N.localize("sessionNotAuthenticated", new Object[0])));
        }
        AuthenticationUtils.destroySession(session);
        response.setHeader("Content-type", "text/html");
        HttpUtils.setNoCache(response);
        RequestDispatcher view = request.getRequestDispatcher(LOG_OFF_PATH);
        view.include((ServletRequest)request, (ServletResponse)response);
        return Promises.resolve(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Promise<T> processRequest(HttpServletRequest request, LoginRequestVisitor<T> processor) {
        LoginRelayData loginRelayData;
        String state = request.getParameter(STATE_PARAM);
        Map<String, LoginRelayData> map = LOGIN_DATA_BY_UUID;
        synchronized (map) {
            loginRelayData = LOGIN_DATA_BY_UUID.remove(state);
        }
        if (loginRelayData == null) {
            return processor.processInvalidRequest();
        }
        return loginRelayData.isRemoteLogin() ? processor.processRemoteLogin(loginRelayData.getRequestId(), loginRelayData.getResponseEndpoint()) : processor.processLogin(loginRelayData.getResponseEndpoint());
    }

    public RemoteLoginRequestVerifier getRemoteLoginVerifier() {
        return this._remoteLoginVerifier;
    }

    public LsppServiceEndpoint getVapiEndpoint() {
        return this._oauth2Context.getVapiEndpoint();
    }

    public LsppService getSsoRegistration() {
        return this._ssoContext.getSsoRegistration();
    }

    public SsoContext getSsoContext() {
        return this._ssoContext;
    }

    public URI getTokenEndpoint() {
        return this._oauth2Context.getTokenEndpoint();
    }

    public Map<String, List<String>> getQueryParams() {
        return this._oauth2Context.getAuthQueryParams();
    }

    public URI getAppRedirectUrl() {
        return this._oauth2Context.getAppOAuth2RedirectUrl();
    }

    public URI getRemoteLoginRedirectUrl() {
        return this._oauth2Context.getAppOAuth2RemoteLoginRedirectUrl();
    }

    public String getClientId() {
        return this._oauth2Context.getClientId();
    }

    public String getClientSecret() {
        return this._oauth2Context.getClientSecret();
    }

    private String buildAuthCodeRequestUrl(String requestId, String redirectPath, boolean isRemoteLogin) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)this._oauth2Context.getAuthEndpoint()).queryParam(CLIENT_ID_PARAM, new Object[]{this._oauth2Context.getClientId()}).queryParam(REDIRECT_URI_PARAM, new Object[]{isRemoteLogin ? this._oauth2Context.getAppOAuth2RemoteLoginRedirectUrl() : this._oauth2Context.getAppOAuth2RedirectUrl()}).queryParam(STATE_PARAM, new Object[]{this.generateStateParam(requestId, redirectPath, isRemoteLogin)});
        for (Map.Entry<String, List<String>> e : this._oauth2Context.getAuthQueryParams().entrySet()) {
            builder = builder.queryParam(e.getKey(), (Collection)e.getValue());
        }
        return builder.toUriString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateStateParam(String requestId, String redirectPath, boolean isRemoteLogin) {
        String key = UUID.randomUUID().toString();
        Map<String, LoginRelayData> map = LOGIN_DATA_BY_UUID;
        synchronized (map) {
            LOGIN_DATA_BY_UUID.put(key, new LoginRelayData(isRemoteLogin, redirectPath, requestId));
        }
        return key;
    }

    private static final class LoginRelayData {
        private final boolean _isRemoteLogin;
        private final String _responseEndpoint;
        private final String _requestId;

        public boolean isRemoteLogin() {
            return this._isRemoteLogin;
        }

        public String getResponseEndpoint() {
            return this._responseEndpoint;
        }

        public String getRequestId() {
            return this._requestId;
        }

        private LoginRelayData(boolean isRemoteLogin, String responseEndpoint, String requestId) {
            this._isRemoteLogin = isRemoteLogin;
            this._responseEndpoint = responseEndpoint;
            this._requestId = requestId;
        }
    }

    public static interface LoginRequestVisitor<T> {
        public Promise<T> processLogin(String var1);

        public Promise<T> processRemoteLogin(String var1, String var2);

        public Promise<T> processInvalidRequest();
    }
}

