/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.authorization;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.PromiseResult;
import com.vmware.dr.ui.tools.reactive.Publisher;
import com.vmware.dr.ui.tools.reactive.Stream;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.reactive.impl.Streams;
import com.vmware.srm.client.infrastructure.authorization.PrivilegeCheckHelper;
import com.vmware.srm.client.infrastructure.authorization.data.EntityPrivilege;
import com.vmware.srm.client.infrastructure.authorization.data.PrivilegeCheckRequest;
import com.vmware.srm.client.infrastructure.authorization.data.PrivilegeCheckRequestList;
import com.vmware.srm.client.infrastructure.commonData.MoRefData;
import com.vmware.srm.client.infrastructure.exceptions.ExceptionUtil;
import com.vmware.srm.client.infrastructure.requestHandlers.DrInputType;
import com.vmware.srm.client.infrastructure.requestHandlers.FreeRequestHandler;
import com.vmware.srm.client.infrastructure.requestHandlers.context.FreeRequestContext;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.DrData;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.impl.DrDataList;
import com.vmware.srm.client.topology.client.view.Server;
import com.vmware.srm.client.topology.client.view.availability.hms.HmsServer;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServer;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServersView;
import com.vmware.srm.client.topology.client.view.vc.VcServer;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DrInputType(value=PrivilegeCheckRequestList.class)
public class PrivilegeCheckRequestHandler
implements FreeRequestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrivilegeCheckRequestHandler.class);

    @Override
    public Promise<DrDataList<EntityPrivilege>> handle(DrData input, FreeRequestContext context) {
        PrivilegeCheckRequestList requests = (PrivilegeCheckRequestList)input;
        DrDataList<PrivilegeCheckRequest> requestsList = requests.getRequestList();
        Validate.notEmpty(requestsList, (String)"request.requestList");
        List entityPrivilegePromises = requestsList.stream().map(request -> this.handleSingleRequest((PrivilegeCheckRequest)request, context)).collect(Collectors.toList());
        Stream privilegeRequests = Streams.empty();
        for (Promise promise : entityPrivilegePromises) {
            privilegeRequests = privilegeRequests.merge(new Publisher[]{promise});
        }
        return privilegeRequests.collect().thenApply(results -> {
            DrDataList result = new DrDataList();
            results.stream().forEach(items -> result.addAll(items));
            return result;
        });
    }

    private Promise<List<EntityPrivilege>> handleSingleRequest(PrivilegeCheckRequest request, FreeRequestContext context) {
        Object[] moRefs = request.getTargetObjects();
        Object[] privilegeIds = request.getPrivilegeIds();
        Validate.notEmpty((Object[])moRefs, (String)"targetObject");
        Validate.notEmpty((Object[])privilegeIds, (String)"privilegeIds");
        String serverGuid = moRefs[0].getServerGuid();
        return context.view().getServerBy(serverGuid).materialize().thenCompose(arg_0 -> this.lambda$handleSingleRequest$7((MoRefData[])moRefs, context, request, arg_0));
    }

    private MoRefData translateFakeMoRefType(MoRefData moref) {
        String type;
        switch (moref.getType()) {
            case "DrRecoveryRootFolder": 
            case "DrRecoveryFolder": 
            case "DrReplicationRootFolder": 
            case "DrReplicationFolder": {
                type = "DrFolder";
                break;
            }
            default: {
                type = moref.getType();
            }
        }
        return new MoRefData(type, moref.getValue(), moref.getServerGuid());
    }

    private /* synthetic */ Promise lambda$handleSingleRequest$7(MoRefData[] moRefs, FreeRequestContext context, PrivilegeCheckRequest request, PromiseResult serverResult) {
        if (!serverResult.isSuccessful()) {
            return Promises.resolve(PrivilegeCheckHelper.createErrorResult(moRefs, serverResult.getError()));
        }
        Server server = (Server)serverResult.getResult();
        if (server instanceof SrmServer) {
            HashMap moRefsMap = new HashMap();
            ManagedObjectReference[] moRefsToCheck = Arrays.stream(moRefs).map(moRef -> {
                MoRefData newMoRef = this.translateFakeMoRefType((MoRefData)moRef);
                moRefsMap.put(moRef.getValue(), moRef);
                return newMoRef;
            }).collect(Collectors.toList()).toArray(new MoRefData[moRefs.length]);
            return PrivilegeCheckHelper.hasSrmPrivilegeOnEntities((SrmServersView)context.view(), request.getPrivilegeIds(), moRefsToCheck).thenApply(entityPrivileges -> {
                entityPrivileges.stream().forEach(item -> item.setMoRef((MoRefData)moRefsMap.get(item.getMoRef().getValue())));
                return entityPrivileges;
            });
        }
        if (server instanceof VcServer) {
            if (moRefs.length == 1) {
                return PrivilegeCheckHelper.hasVcPrivilegeOnEntity((VcServer)server, request.getPrivilegeIds(), moRefs[0]).thenApply(xva$0 -> Arrays.asList(xva$0));
            }
            return PrivilegeCheckHelper.hasVcPrivilegeOnEntities((VcServer)server, request.getPrivilegeIds(), moRefs);
        }
        if (server instanceof HmsServer) {
            return PrivilegeCheckHelper.hasHmsPrivilegeOnEntities((HmsServer)server, request.getPrivilegeIds(), moRefs);
        }
        LOGGER.error("Privilege check for unsupported server type.");
        return Promises.reject((Exception)ExceptionUtil.getRuntimeException("unknownServerType"));
    }
}

