/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.health.lsppconsistency;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.Publisher;
import com.vmware.dr.ui.tools.reactive.Stream;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.reactive.impl.Streams;
import com.vmware.srm.client.topology.client.vmomi.Service;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.BaseLsppNode;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.LsppConsistencyWatcher;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.utils.LsppHelper;
import com.vmware.srm.client.topology.impl.lspp.LsppNegotiator;
import com.vmware.srm.client.topology.impl.lspp.Types;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppService;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppServiceEndpoint;
import com.vmware.srm.client.topology.impl.sso.CertificateUtils;
import com.vmware.srm.client.topology.impl.vmomi.hms.HmsServiceImpl;
import com.vmware.srm.client.topology.impl.vmomi.is.InventoryServiceImpl;
import com.vmware.srm.client.topology.impl.vmomi.pbm.SpbmServiceImpl;
import com.vmware.srm.client.topology.impl.vmomi.srm.SrmServiceImpl;
import com.vmware.srm.client.topology.impl.vmomi.vc.VcServiceImpl;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.VmomiServiceImpl;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LsppConsistencyChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(LsppConsistencyChecker.class);
    private final URI _lsppUrl;
    private final String _lsppThumbprint;
    private final LsppConsistencyWatcher _watcher = new LsppConsistencyWatcher(this::federationChanged);
    private final AtomicBoolean _ran = new AtomicBoolean(false);

    public LsppConsistencyChecker(URI lsppUrl, String lsppThumbprint) {
        this._lsppUrl = lsppUrl;
        this._lsppThumbprint = lsppThumbprint;
    }

    public Promise<Void> doCheck() {
        Promise servicesMap;
        Promise<Void> testFederation;
        if (this._ran.getAndSet(true)) {
            return Promises.reject((Exception)new IllegalStateException("Already ran."));
        }
        LOGGER.info("Starting check for PSC at '{}'", (Object)this._lsppUrl);
        LsppNegotiator ln = new LsppNegotiator(this._lsppUrl, this._lsppThumbprint);
        try {
            testFederation = this.testFederation(ln);
            servicesMap = LsppHelper.listServers((LsppNegotiator)ln, (Types.LsppType[])new Types.LsppType[]{Types.LsppType.Sso, Types.LsppType.Vc, Types.LsppType.Spbm, Types.LsppType.Srm, Types.LsppType.Hms});
        }
        catch (Exception exc) {
            LOGGER.error("Failed to perform check for PSC at '{}': ", (Object)this._lsppUrl, (Object)exc);
            ln.close();
            return Promises.reject((Exception)exc);
        }
        testFederation.materialize().thenCombine(servicesMap.materialize(), (u1, u2) -> {
            ln.close();
            return null;
        });
        return servicesMap.thenCompose(this::checkServers);
    }

    private Promise<Void> checkServers(Map<Types.LsppType, Set<LsppService>> map) {
        VmomiProbeHelper vcHelper = new VmomiProbeHelper("com.vmware.vim", "vmomi"){

            @Override
            protected VmomiServiceImpl<?, ?> createService(LsppService vcReg, URI url, KeyStore trustStore) {
                return new VcServiceImpl(url, trustStore, null);
            }
        };
        VmomiProbeHelper spbmHelper = new VmomiProbeHelper("com.vmware.vim.pbm", "https"){

            @Override
            protected VmomiServiceImpl<?, ?> createService(LsppService spbmReg, URI url, KeyStore trustStore) {
                return new SpbmServiceImpl(url, trustStore, null, () -> Promises.resolve(null));
            }
        };
        VmomiProbeHelper isHelper = new VmomiProbeHelper("com.vmware.cis.inventory.server", "vmomi"){

            @Override
            protected VmomiServiceImpl<?, ?> createService(LsppService spbmReg, URI url, KeyStore trustStore) {
                return new InventoryServiceImpl(url, trustStore, null);
            }
        };
        VmomiProbeHelper srmHelper = new VmomiProbeHelper("com.vmware.dr.vcDr", "vmomi"){

            @Override
            protected VmomiServiceImpl<?, ?> createService(LsppService reg, URI url, KeyStore trustStore) {
                return new SrmServiceImpl(url, trustStore, null, reg.getAttributes().getOrDefault("supportedVmodlVersions", "/vcdr/vmomi/drserviceversions.xml"));
            }
        };
        VmomiProbeHelper hmsHelper = new VmomiProbeHelper("com.vmware.vim.hms", "vmomi"){

            @Override
            protected VmomiServiceImpl<?, ?> createService(LsppService reg, URI url, KeyStore trustStore) {
                return new HmsServiceImpl(url, trustStore, null);
            }
        };
        Stream all = Streams.empty();
        for (Map.Entry<Types.LsppType, Set<LsppService>> entry : map.entrySet()) {
            for (LsppService ssoReg : entry.getValue()) {
                switch (entry.getKey()) {
                    case Sso: {
                        LsppNegotiator nestedLn = BaseLsppNode.createNegotiator((LsppService)ssoReg);
                        Promise testFed = this.testFederation(nestedLn).materialize().onSuccess(unused -> nestedLn.close()).thenApply(unused -> null);
                        all = all.merge(new Publisher[]{testFed});
                        break;
                    }
                    case Vc: {
                        all = all.merge(new Publisher[]{vcHelper.probe(ssoReg).materialize().thenApply(unused -> null)});
                        break;
                    }
                    case Spbm: {
                        all = all.merge(new Publisher[]{spbmHelper.probe(ssoReg).materialize().thenApply(unused -> null)});
                        break;
                    }
                    case Is: {
                        all = all.merge(new Publisher[]{isHelper.probe(ssoReg).materialize().thenApply(unused -> null)});
                        break;
                    }
                    case Srm: {
                        all = all.merge(new Publisher[]{srmHelper.probe(ssoReg).materialize().thenApply(unused -> null)});
                        break;
                    }
                    case Hms: {
                        all = all.merge(new Publisher[]{hmsHelper.probe(ssoReg).materialize().thenApply(unused -> null)});
                    }
                }
            }
        }
        return all.collect().materialize().thenApply(pr -> {
            LOGGER.info("Completed check for PSC at '{}'", (Object)this._lsppUrl);
            return null;
        });
    }

    private Promise<Void> testFederation(LsppNegotiator ln) {
        return ln.query(Types.SSO).materialize().thenApply(pr -> {
            if (!pr.isSuccessful()) {
                LOGGER.error("Failed to connect to LSPP at '{}':", (Object)ln.getUrl(), (Object)pr.getError());
            } else if (!this._watcher.tryAdd((Set)pr.getResult(), () -> ((LsppNegotiator)ln).getUrl())) {
                LOGGER.error("Inconsistent PSC federation at '{}'", (Object)ln.getUrl());
            } else {
                LOGGER.info("Connection to LSPP at '{}' OK.", (Object)ln.getUrl());
            }
            return null;
        });
    }

    private Promise<Void> probeVmomiServer(Service<?, ?> service) {
        return service.getContent().materialize().thenApply(pr -> {
            if (pr.isSuccessful()) {
                LOGGER.info("Connection to '{}' OK.", (Object)service);
            } else {
                LOGGER.warn("Failed to connect to '{}':", (Object)service, (Object)pr.getError());
            }
            return null;
        });
    }

    private void federationChanged(LsppConsistencyWatcher watcher, URI lsppUrl) {
    }

    private abstract class VmomiProbeHelper {
        private final String _epType;
        private final String _epProtocol;

        VmomiProbeHelper(String epType, String epProtocol) {
            this._epType = epType;
            this._epProtocol = epProtocol;
        }

        protected abstract VmomiServiceImpl<?, ?> createService(LsppService var1, URI var2, KeyStore var3);

        final Promise<Void> probe(LsppService vmomiReg) {
            KeyStore store;
            LsppServiceEndpoint vmomiEp = LsppHelper.getEndpoint((LsppService)vmomiReg, (String)this._epProtocol, (String)this._epType);
            if (vmomiEp == null) {
                return Promises.reject((Exception)new RuntimeException("No vmomi endpoint found for " + vmomiReg));
            }
            try {
                store = CertificateUtils.createTrustStore((Collection)vmomiEp.getCertificates());
            }
            catch (IOException | GeneralSecurityException e) {
                return Promises.reject((Exception)e);
            }
            VmomiServiceImpl<?, ?> service = this.createService(vmomiReg, vmomiEp.url, store);
            Promise<Void> result = LsppConsistencyChecker.this.probeVmomiServer((Service<?, ?>)service);
            result.materialize().onSuccess(unused -> service.dispose());
            return result;
        }
    }
}

