/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.localization.catalogManager;

import com.vmware.srm.client.infrastructure.localization.LocalizationUtil;
import com.vmware.srm.client.infrastructure.localization.catalogManager.CatalogUpdater;
import com.vmware.srm.client.topology.client.Topology;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VcCatalogManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(VcCatalogManager.class);
    private static long INTERVAL = 300000L;
    private final CatalogUpdater _updater;
    private final AtomicBoolean _isRunning = new AtomicBoolean(false);
    private volatile Date _expireTime = new Date(0L);

    public VcCatalogManager(String basePath) {
        this._updater = new CatalogUpdater(basePath);
    }

    public void process(Topology topology) {
        Date now = new Date();
        if (now.after(this._expireTime) && this._isRunning.compareAndSet(false, true)) {
            this._updater.update(topology).materialize().onSuccess(pr -> {
                try {
                    if (pr.isSuccessful()) {
                        this._expireTime = new Date(System.currentTimeMillis() + INTERVAL);
                        if ((Integer)pr.getResult() > 0) {
                            LocalizationUtil.reload();
                        }
                    } else {
                        LOGGER.warn("Failed to update catalogs.", (Throwable)pr.getError());
                    }
                }
                finally {
                    this._isRunning.set(false);
                }
            });
        }
    }
}

