/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.pc.utils;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.Publisher;
import com.vmware.dr.ui.tools.reactive.Stream;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.reactive.impl.Streams;
import com.vmware.dr.ui.tools.utilities.Pair;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.client.vmomi.Service;
import com.vmware.srm.client.topology.impl.utils.Utils;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vim.vmomi.core.Future;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.lang.Validate;

public class RetrievePropertiesImpl {
    private static final PropertyCollector.RetrieveOptions RETRIEVE_OPTIONS = new PropertyCollector.RetrieveOptions(Integer.valueOf(100));
    private final Service<?, ?> _service;
    private final PropertyCollector.FilterSpec[] _specs;
    private final String _guid;

    RetrievePropertiesImpl(String guid, Service<?, ?> service, Collection<PropertyCollector.FilterSpec> specs) {
        Validate.notNull(service, (String)"service");
        Validate.notEmpty(specs, (String)"specs");
        this._service = service;
        this._specs = specs.toArray(new PropertyCollector.FilterSpec[0]);
        this._guid = guid;
    }

    public String getGuid() {
        return this._guid;
    }

    public PropertyCollector.FilterSpec[] getFilterSpec() {
        return this._specs;
    }

    public Promise<Collection<PropertyCollector.RetrieveResult>> retrieveProperties() {
        return Utils.getPropertyCollectorForService(this._service).thenCompose(pcRef -> {
            PropertyCollector pc = (PropertyCollector)this._service.createStub(pcRef);
            FuturePromise fp = new FuturePromise();
            pc.retrievePropertiesEx(this._specs, RETRIEVE_OPTIONS, (Future)fp);
            return fp.thenApply(retrieveResult -> new Pair((Object)pc, retrieveResult));
        }).toStream().flatMap(pair -> this.continueStream((PropertyCollector)pair.first(), (PropertyCollector.RetrieveResult)pair.second())).reduce(new LinkedList(), (list, next) -> {
            list.add(next);
            return list;
        });
    }

    private Stream<PropertyCollector.RetrieveResult> continueStream(PropertyCollector pc, PropertyCollector.RetrieveResult rr) {
        if (rr == null) {
            return Streams.empty();
        }
        if (rr.token == null) {
            return Streams.just((Object[])new PropertyCollector.RetrieveResult[]{rr});
        }
        FuturePromise result = new FuturePromise();
        pc.continueRetrievePropertiesEx(rr.token, (Future)result);
        return Streams.from((Publisher[])new Publisher[]{Promises.resolve((Object)rr), result.toStream().flatMap(newRr -> this.continueStream(pc, (PropertyCollector.RetrieveResult)newRr))});
    }
}

