/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.tasks;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.infrastructure.tasks.TaskMonitor;
import com.vmware.srm.client.infrastructure.tasks.TasksFacade;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.client.vmomi.Service;
import com.vmware.vim.binding.vim.Task;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import java.util.Calendar;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang.Validate;

public class TaskUtil {
    public static boolean isComplete(TaskInfo taskInfo) {
        return TaskInfo.State.error.equals((Object)taskInfo.state) || TaskInfo.State.success.equals((Object)taskInfo.state);
    }

    @Deprecated
    public static <T> Promise<T> waitForTaskToFinish(Service<?, ?> service, ManagedObjectReference taskMoRef) {
        if (TasksFacade.isManagedTask(taskMoRef)) {
            return TasksFacade.monitorManagedTask(taskMoRef);
        }
        Task task = (Task)service.createStub(taskMoRef);
        TaskMonitor taskMonitor = new TaskMonitor(task);
        return taskMonitor.start();
    }

    public static Promise<TaskInfo> getTaskInfo(Service<?, ?> service, ManagedObjectReference taskMoRef) {
        if (TasksFacade.isManagedTask(taskMoRef)) {
            try {
                return Promises.resolve((Object)TasksFacade.getTaskProgress(taskMoRef));
            }
            catch (Exception exc) {
                return Promises.reject((Exception)exc);
            }
        }
        Task task = (Task)service.createStub(taskMoRef);
        FuturePromise taskInfoFuture = new FuturePromise();
        task.getInfo((Future)taskInfoFuture);
        return taskInfoFuture;
    }

    public static TaskInfo createInitialTaskInfo(ManagedObjectReference moref) {
        TaskInfo info = new TaskInfo();
        info.task = moref;
        info.state = TaskInfo.State.running;
        info.progress = 0;
        info.startTime = Calendar.getInstance();
        info.descriptionId = "";
        return info;
    }

    public static <T> ManagedObjectReference toManagedTask(T result) {
        return TasksFacade.createManagedTask(handle -> handle.complete(result));
    }

    public static <T> ManagedObjectReference toManagedTask(Supplier<Promise<T>> supplier) {
        Validate.notNull(supplier, (String)"supplier");
        return TasksFacade.createManagedTask(handle -> ((Promise)supplier.get()).onSuccess(handle::complete).onError(handle::fail));
    }

    public static <T, U> ManagedObjectReference toManagedTask(Task task, Function<T, Promise<U>> resultHandler) {
        return TaskUtil.toManagedTask(() -> new TaskMonitor(task).start().thenCompose(resultHandler));
    }
}

