/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.websso;

import com.vmware.identity.websso.client.AuthnData;
import com.vmware.identity.websso.client.IDPConfiguration;
import com.vmware.identity.websso.client.LogonProcessor;
import com.vmware.identity.websso.client.Message;
import com.vmware.identity.websso.client.MessageStore;
import com.vmware.identity.websso.client.MessageStoreImpl;
import com.vmware.identity.websso.client.SPConfiguration;
import com.vmware.identity.websso.client.SsoRequestSettings;
import com.vmware.identity.websso.client.ValidationResult;
import com.vmware.identity.websso.client.WebssoClientException;
import com.vmware.identity.websso.client.endpoint.SsoRequestSender;
import com.vmware.identity.websso.client.endpoint.SsoResponseListener;
import com.vmware.srm.client.infrastructure.utils.L10N;
import com.vmware.srm.client.infrastructure.websso.SsoContext;
import com.vmware.srm.client.infrastructure.websso.WebSsoWorkflow;
import com.vmware.vim.sso.client.DefaultTokenFactory;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.exception.InvalidTokenException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import javax.naming.ConfigurationException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.core.xml.io.MarshallingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public abstract class LoginWorkflow
extends WebSsoWorkflow {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoginWorkflow.class);
    private static final MessageStore MSG_STORE = new MessageStoreImpl();
    private final SsoContext _context;
    private final String _defaultOnSuccessPath;
    private final SPConfiguration _spConfig;
    private final IDPConfiguration _idpConfig;
    private final SsoRequestSender _requestSender;
    private final SsoResponseListener _responseListener;

    protected LoginWorkflow(SsoContext context, String defaultOnSuccessPath) throws NoSuchAlgorithmException {
        this._context = context;
        this._defaultOnSuccessPath = defaultOnSuccessPath;
        this._spConfig = this._context.getSpConfig();
        this._idpConfig = this._context.getIDPConfig();
        this._requestSender = new SsoRequestSender();
        this._requestSender.setLogonProcessor((LogonProcessor)new LoginRequestProcessor());
        this._requestSender.setMessageStore(MSG_STORE);
        this._requestSender.setMetadataSettings(this._context.getMetadataSettings());
        this._responseListener = new SsoResponseListener();
        this._responseListener.setLogonProcessor((LogonProcessor)new LoginResponseProcessor());
        this._responseListener.setMessageStore(MSG_STORE);
        this._responseListener.setMetadataSettings(this._context.getMetadataSettings());
    }

    public void start(HttpServletRequest request, HttpServletResponse response, String onSuccessPath) throws InvalidKeyException, NoSuchAlgorithmException, IOException, ConfigurationException, MarshallingException, WebssoClientException {
        this._requestSender.sendRequest(this.createRequestSettings(onSuccessPath), response);
    }

    public void complete(HttpServletRequest request, HttpServletResponse response) {
        this._responseListener.consumeResponse(this._spConfig.getAlias(), request, response);
    }

    protected abstract void onSuccess(SamlToken var1, String var2, String var3, String var4, SsoContext var5, HttpServletRequest var6, HttpServletResponse var7);

    private SsoRequestSettings createRequestSettings(String onSuccessPath) {
        SsoRequestSettings result = new SsoRequestSettings(this._spConfig.getAlias(), this._idpConfig.getAlias());
        result.setIsRenewable(Boolean.valueOf(true));
        result.setIsDelegable(Boolean.valueOf(true));
        result.setIsSigned(Boolean.valueOf(true));
        result.setRelayState(LoginWorkflow.encodeBase64(onSuccessPath));
        return result;
    }

    private class LoginResponseProcessor
    implements LogonProcessor {
        private LoginResponseProcessor() {
        }

        public void authenticationError(Message msg, HttpServletRequest request, HttpServletResponse response) {
            ValidationResult validation = msg.getValidationResult();
            String errMsg = validation == null ? L10N.localize("websso.unknownError", new Object[0]) : (validation.getResponseCode() == 200 ? L10N.localize("websso.messageServerError", validation.getStatus(), validation.getSubstatus()) : L10N.localize("websso.messageDetail", validation.getResponseCode(), validation.getStatus(), validation.getSubstatus()));
            WebSsoWorkflow.handleError(response, 400, errMsg);
        }

        public void authenticationSuccess(Message msg, HttpServletRequest request, HttpServletResponse response) {
            String redirectPath;
            SamlToken token;
            AuthnData auth = (AuthnData)msg.getMessageData();
            try {
                token = DefaultTokenFactory.createTokenFromDom((Element)auth.getToken().getDocumentElement(), (X509Certificate[])LoginWorkflow.this._context.getSigningCerts(), (long)LoginWorkflow.this._context.getClockTolerance());
            }
            catch (InvalidTokenException e) {
                LOGGER.error("Failed to create saml token.", (Throwable)e);
                WebSsoWorkflow.handleError(response, 500, e.getLocalizedMessage());
                return;
            }
            String sessionIndex = msg.getSessionIndex();
            String subject = auth.getSubjectData().getSubject();
            try {
                redirectPath = WebSsoWorkflow.decodeBase64(msg.getRelayState());
            }
            catch (Exception e) {
                LOGGER.warn("Failed retrieve 'successPath' from message.", (Throwable)e);
                redirectPath = LoginWorkflow.this._defaultOnSuccessPath;
            }
            LoginWorkflow.this.onSuccess(token, subject, sessionIndex, redirectPath, LoginWorkflow.this._context, request, response);
        }

        public void internalError(Exception exc, HttpServletRequest request, HttpServletResponse response) {
            LOGGER.error("Failed to process login response:", (Throwable)exc);
            WebSsoWorkflow.handleError(response, 500, exc.getLocalizedMessage());
        }
    }

    private class LoginRequestProcessor
    implements LogonProcessor {
        private LoginRequestProcessor() {
        }

        public void authenticationError(Message msg, HttpServletRequest request, HttpServletResponse response) {
        }

        public void authenticationSuccess(Message msg, HttpServletRequest request, HttpServletResponse response) {
        }

        public void internalError(Exception exc, HttpServletRequest request, HttpServletResponse response) {
            LOGGER.error("Sending login request failed:", (Throwable)exc);
            WebSsoWorkflow.handleError(response, 500, exc.getLocalizedMessage());
        }
    }
}

