/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.websso;

import com.vmware.identity.websso.client.AssertionConsumerService;
import com.vmware.identity.websso.client.SPConfiguration;
import com.vmware.identity.websso.client.SingleLogoutService;
import com.vmware.srm.client.infrastructure.websso.XmlUtils;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang.Validate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class SpConfigSerializer {
    private static final ThreadLocal<Document> DOC = new ThreadLocal<Document>(){

        @Override
        protected Document initialValue() {
            try {
                return XmlUtils.createBuiler().newDocument();
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException("Unable to create new document.", e);
            }
        }
    };
    private static final ThreadLocal<SPConfiguration> SP_CONFIG = new ThreadLocal();

    private static void initThreadLocals(SPConfiguration spConfig) {
        DOC.remove();
        SP_CONFIG.set(spConfig);
    }

    private static Document doc() {
        return DOC.get();
    }

    private static SPConfiguration config() {
        return SP_CONFIG.get();
    }

    public String getStringValue(SPConfiguration spConfig) throws ParserConfigurationException, IOException, TransformerException {
        Validate.notNull((Object)spConfig, (String)"spConfig");
        SpConfigSerializer.initThreadLocals(spConfig);
        this.createEntitiesDescriptor();
        return XmlUtils.documentToString(SpConfigSerializer.doc());
    }

    private void createEntitiesDescriptor() {
        Element root = SpConfigSerializer.doc().createElementNS("urn:oasis:names:tc:SAML:2.0:metadata", "EntitiesDescriptor");
        root.setAttribute("xmlns:saml", "urn:oasis:names:tc:SAML:2.0:assertion");
        root.setAttribute("Name", SpConfigSerializer.config().getAlias());
        this.createSPEntityDescriptor(root);
        SpConfigSerializer.doc().appendChild(root);
    }

    private void createSPEntityDescriptor(Element root) {
        Element spEntityDescriptor = SpConfigSerializer.doc().createElementNS("urn:oasis:names:tc:SAML:2.0:metadata", "EntityDescriptor");
        spEntityDescriptor.setAttribute("entityID", SpConfigSerializer.config().getEntityID());
        this.createSPSSODescriptor(spEntityDescriptor);
        root.appendChild(spEntityDescriptor);
    }

    private void createSPSSODescriptor(Element parent) {
        Element spSsoDescriptor = SpConfigSerializer.doc().createElement("SPSSODescriptor");
        spSsoDescriptor.setAttribute("AuthnRequestsSigned", Boolean.toString(SpConfigSerializer.config().isAuthnRequestsSigned()));
        spSsoDescriptor.setAttribute("protocolSupportEnumeration", "urn:oasis:names:tc:SAML:2.0:protocol");
        this.createSPKeyDescriptor(spSsoDescriptor);
        this.createSingleLogoutServices(spSsoDescriptor);
        this.createNameIDFormat(spSsoDescriptor);
        this.createAssertionConsumerServices(spSsoDescriptor);
        parent.appendChild(spSsoDescriptor);
    }

    private void createSPKeyDescriptor(Element parent) {
        Element keyDescriptor = SpConfigSerializer.doc().createElement("KeyDescriptor");
        keyDescriptor.setAttribute("xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
        keyDescriptor.setAttribute("use", "signing");
        this.createKeyInfo(keyDescriptor);
        parent.appendChild(keyDescriptor);
    }

    private void createKeyInfo(Element parent) {
        Element keyInfo = SpConfigSerializer.doc().createElement("ds:KeyInfo");
        this.createX509Data(keyInfo);
        parent.appendChild(keyInfo);
    }

    private void createX509Data(Element parent) {
        Element x509Data = SpConfigSerializer.doc().createElement("ds:X509Data");
        this.createCertificate(x509Data);
        parent.appendChild(x509Data);
    }

    private void createCertificate(Element parent) {
        String base64Encoded;
        Element x509Certificate = SpConfigSerializer.doc().createElement("ds:X509Certificate");
        X509Certificate cert = SpConfigSerializer.config().getSigningCertificate();
        try {
            base64Encoded = Base64.getEncoder().encodeToString(cert.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new RuntimeException("Unable to encode certificate.", e);
        }
        Text certText = SpConfigSerializer.doc().createTextNode(base64Encoded);
        x509Certificate.appendChild(certText);
        parent.appendChild(x509Certificate);
    }

    private void createSingleLogoutServices(Element parent) {
        for (SingleLogoutService service : SpConfigSerializer.config().getSingleLogoutServices()) {
            Element sloElement = SpConfigSerializer.doc().createElement("SingleLogoutService");
            String location = service.getLocation();
            String responseLocation = service.getResponseLocation();
            sloElement.setAttribute("Binding", service.getBinding());
            sloElement.setAttribute("Location", location);
            sloElement.setAttribute("ResponseLocation", responseLocation);
            parent.appendChild(sloElement);
        }
    }

    private void createNameIDFormat(Element parent) {
        for (String format : SpConfigSerializer.config().getNameIDFormats()) {
            Element nameIDFormat = SpConfigSerializer.doc().createElement("NameIDFormat");
            nameIDFormat.appendChild(SpConfigSerializer.doc().createTextNode(format));
            parent.appendChild(nameIDFormat);
        }
    }

    private void createAssertionConsumerServices(Element parent) {
        for (AssertionConsumerService service : SpConfigSerializer.config().getAssertionConsumerServices()) {
            Element acsElement = SpConfigSerializer.doc().createElement("AssertionConsumerService");
            acsElement.setAttribute("Binding", service.getBinding());
            acsElement.setAttribute("Location", service.getLocation());
            acsElement.setAttribute("index", Integer.toString(service.getIndex()));
            if (service.isDefault()) {
                acsElement.setAttribute("isDefault", "true");
            }
            parent.appendChild(acsElement);
        }
    }
}

