/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.dr.ui.tools.reactive;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.Publisher;
import com.vmware.dr.ui.tools.reactive.Subscriber;
import com.vmware.dr.ui.tools.reactive.impl.Streams;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public interface Stream<T>
extends Publisher<T> {
    public Stream<T> filter(Predicate<? super T> var1);

    public <R> Stream<R> map(Function<? super T, ? extends R> var1);

    public <R> Stream<R> flatMap(Function<? super T, ? extends Publisher<? extends R>> var1);

    public <U> Promise<U> reduce(U var1, BiFunction<U, ? super T, U> var2);

    default public Promise<Collection<T>> collect() {
        return this.reduce(new ArrayList(), (list, next) -> {
            list.add(next);
            return list;
        });
    }

    default public void consume(final Consumer<T> consumer) {
        this.subscribe(new Subscriber<T>(){

            @Override
            public void onNext(T item) {
                consumer.accept(item);
            }

            @Override
            public void onComplete(boolean cancelled) {
            }

            @Override
            public void onError(Exception err) {
            }
        });
    }

    default public Stream<T> merge(Publisher<T> ... publishers) {
        Publisher<T>[] args = Arrays.copyOf(publishers, publishers.length + 1);
        args[args.length - 1] = this;
        return Streams.from(args);
    }

    public Promise<T> next();

    public Stream<StreamEvent<T>> materialize();

    public static final class StreamEvent<T> {
        public final StreamEventType type;
        public final T item;
        public final Exception error;

        public StreamEvent(StreamEventType type, T item, Exception error) {
            this.type = type;
            this.item = item;
            this.error = error;
        }
    }

    public static enum StreamEventType {
        item,
        complete,
        error;

    }

    public static class StreamCompleteException
    extends RuntimeException {
    }
}

