/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.dr.ui.tools.reactive.impl;

import com.vmware.dr.ui.tools.reactive.Dispatcher;
import com.vmware.dr.ui.tools.reactive.Subscriber;
import com.vmware.dr.ui.tools.reactive.Subscription;
import com.vmware.dr.ui.tools.reactive.impl.AsyncDispatcherImpl;
import com.vmware.dr.ui.tools.reactive.impl.PublisherImpl;
import com.vmware.dr.ui.tools.reactive.impl.StreamImpl;
import com.vmware.dr.ui.tools.reactive.impl.SubscriberWrapper;
import com.vmware.dr.ui.tools.reactive.impl.SyncDispatcherImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.Validate;

public class CachingStream<T>
extends StreamImpl<T> {
    private final AtomicReference<Node<T>> _headRef = new AtomicReference<Object>(null);
    private final SyncPublisherImpl _syncPublisher = new SyncPublisherImpl();
    private final Dispatcher _subscriberDispatcher = new AsyncDispatcherImpl();

    public CachingStream() {
        super.subscribe(this._syncPublisher);
    }

    @Override
    public Subscription<T> subscribe(Subscriber<? super T> subscriber) {
        Node<T> end;
        Node<T> start;
        Wrapper<T> wrapper = new Wrapper<T>(subscriber, this._subscriberDispatcher);
        Subscription<? super T> subscription = this._syncPublisher.subscribe(wrapper);
        do {
            start = this._headRef.get();
            end = this.getLast(start);
        } while (start == null && end != null);
        while (true) {
            if (start != end) {
                wrapper.publish(start);
                start = start.next.get();
                continue;
            }
            if (end != null) {
                wrapper.publish(end);
                if (end.isFinal()) {
                    return subscription;
                }
                end.waitToPublish();
            }
            wrapper.record();
            if (end == this.getLast(end)) {
                wrapper.replay();
                return subscription;
            }
            wrapper.discard();
            start = start == null ? this._headRef.get() : start.next.get();
            end = this.getLast(start);
        }
    }

    private Node<T> getLast(Node<T> from) {
        Node<T> node = from = from == null ? this._headRef.get() : from;
        if (from == null) {
            return null;
        }
        Node<T> last = from;
        Node node2 = last.next.get();
        while (node2 != null) {
            last = node2;
            node2 = node2.next.get();
        }
        return last;
    }

    private static final class Node<T> {
        final T item;
        final boolean complete;
        final boolean cancelled;
        final Exception err;
        final AtomicReference<Node<T>> next = new AtomicReference<Object>(null);
        private final CountDownLatch _publishedWaiter = new CountDownLatch(1);

        Node(T item) {
            this.item = item;
            this.complete = false;
            this.cancelled = false;
            this.err = null;
        }

        Node(boolean cancelled) {
            this.item = null;
            this.complete = true;
            this.cancelled = cancelled;
            this.err = null;
        }

        Node(Exception err) {
            Validate.notNull((Object)err, (String)"err");
            this.item = null;
            this.complete = true;
            this.cancelled = false;
            this.err = err;
        }

        boolean isFinal() {
            return this.complete || this.cancelled || this.err != null;
        }

        void publish(Subscriber<T> subscriber, Dispatcher dispatcher) {
            Runnable msg = this.complete ? (this.err == null ? () -> subscriber.onComplete(this.cancelled) : () -> subscriber.onError(this.err)) : () -> subscriber.onNext(this.item);
            dispatcher.dispatch(msg);
        }

        void setPublished() {
            this._publishedWaiter.countDown();
        }

        void waitToPublish() {
            try {
                this._publishedWaiter.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e.getLocalizedMessage(), e);
            }
        }
    }

    private static final class Wrapper<T>
    implements Subscriber<T> {
        private static final int DISCARD = 0;
        private static final int RECORD = 1;
        private static final int REPLAY = 2;
        private static final int PLAY = 3;
        private final Subscriber<T> _subscriber;
        private final Subscriber<? super T> _original;
        private volatile int _state = 0;
        private final List<Node<T>> _buffer = new ArrayList<Node<T>>();
        private final Dispatcher _dispatcher;

        Wrapper(Subscriber<? super T> subscriber, Dispatcher dispatcher) {
            this._subscriber = new SubscriberWrapper<T>(subscriber);
            this._original = subscriber;
            this._dispatcher = dispatcher;
        }

        public boolean equals(Object obj) {
            return this._original.equals(obj);
        }

        public int hashCode() {
            return this._original.hashCode();
        }

        @Override
        public void onNext(T item) {
            this.process(new Node<T>(item));
        }

        @Override
        public void onComplete(boolean cancelled) {
            this.process(new Node(cancelled));
        }

        @Override
        public void onError(Exception err) {
            this.process(new Node(err));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void process(Node<T> node) {
            if (this._state == 0) {
                return;
            }
            if (this._state == 3) {
                node.publish(this._subscriber, this._dispatcher);
                return;
            }
            List<Node<T>> list = this._buffer;
            synchronized (list) {
                if (this._state == 0) {
                    return;
                }
                if (this._state < 3) {
                    this._buffer.add(node);
                    return;
                }
            }
            node.publish(this._subscriber, this._dispatcher);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void record() {
            List<Node<T>> list = this._buffer;
            synchronized (list) {
                this._buffer.clear();
            }
            this._state = 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        void replay() {
            this._state = 2;
            block2: while (true) {
                Node[] nodeArray = this._buffer;
                // MONITORENTER : this._buffer
                if (this._buffer.isEmpty()) {
                    this._state = 3;
                    // MONITOREXIT : nodeArray
                    return;
                }
                Node[] nodes = this._buffer.toArray(new Node[this._buffer.size()]);
                this._buffer.clear();
                // MONITOREXIT : nodeArray
                nodeArray = nodes;
                int n = nodeArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block2;
                    Node node = nodeArray[n2];
                    node.publish(this._subscriber, this._dispatcher);
                    ++n2;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void discard() {
            this._state = 0;
            List<Node<T>> list = this._buffer;
            synchronized (list) {
                this._buffer.clear();
            }
        }

        void publish(Node<T> node) {
            node.publish(this._subscriber, this._dispatcher);
        }
    }

    private final class SyncPublisherImpl
    extends PublisherImpl<T>
    implements Subscriber<T> {
        Node<T> _last;

        SyncPublisherImpl() {
            super(new SyncDispatcherImpl());
        }

        @Override
        public void onNext(T item) {
            Node node = new Node(item);
            this.enqueue(node);
            this.publishNext(item);
            node.setPublished();
        }

        @Override
        public void onComplete(boolean cancelled) {
            Node node = new Node(false);
            this.enqueue(node);
            this.publishComplete();
            node.setPublished();
        }

        @Override
        public void onError(Exception err) {
            Node node = new Node(err);
            this.enqueue(node);
            this.publishError(err);
            node.setPublished();
        }

        private void enqueue(Node<T> node) {
            if (this._last == null) {
                CachingStream.this._headRef.set(node);
            } else {
                this._last.next.set(node);
            }
            this._last = node;
        }
    }
}

