/*
 * Decompiled with CFR 0.152.
 */
package emitters.generators.info;

import emitters.VmodlEmitter;
import emitters.model.ManagedObject;
import emitters.model.Method;
import emitters.model.Version;
import emitters.model.VmodlObject;
import java.io.File;
import java.util.List;
import java.util.Map;

public class ListMethods
extends VmodlEmitter {
    private final String _folderPrefix;
    private final Kind _kind;

    public ListMethods(Map<String, String> options, String folder) {
        this._folderPrefix = folder + File.separator;
        Kind kind = Kind.PUBLIC;
        String kindParameter = options.get("kind");
        if (kindParameter != null) {
            if (kindParameter.equals("public")) {
                kind = Kind.PUBLIC;
            } else if (kindParameter.equals("internal")) {
                kind = Kind.INTERNAL;
            } else {
                throw new RuntimeException("Unsupported info.method.kind: " + kindParameter);
            }
        }
        this._kind = kind;
    }

    @Override
    public void emitObjects(List<VmodlObject> objects) {
        for (VmodlObject object : objects) {
            switch (object.getKind()) {
                case ManagedObject: {
                    this.processManagedObject((ManagedObject)object);
                }
            }
        }
        this.beginFile(this._folderPrefix + "_all_.txt");
        for (VmodlObject object : objects) {
            switch (object.getKind()) {
                case ManagedObject: {
                    this.processManagedObjectAll((ManagedObject)object);
                }
            }
        }
        this.endFile();
    }

    private void processManagedObject(ManagedObject managedObject) {
        String fileName = managedObject.getQualifiedVmodlType().replace(".", File.separator);
        this.beginFile(this._folderPrefix + fileName + ".txt");
        for (Method method : managedObject.getMethodList()) {
            if (!this.shouldEmit(method)) continue;
            this.emitLine(method.getName(), "\t", method.getWsdlName());
        }
        this.endFile();
    }

    private void processManagedObjectAll(ManagedObject managedObject) {
        for (Method method : managedObject.getMethodList()) {
            if (!this.shouldEmit(method)) continue;
            this.emitLine(method.getVmodlName(), "\t", method.getWsdlName());
        }
    }

    private boolean shouldEmit(Method method) {
        if (method.getVersion().getKind() != Version.Kind.LTS) {
            return false;
        }
        if (this._kind == Kind.INTERNAL) {
            return true;
        }
        return !method.isInternal() || method.getInternalBefore() != null;
    }

    private static enum Kind {
        PUBLIC,
        INTERNAL;

    }
}

