/*
 * Decompiled with CFR 0.152.
 */
package emitters.javac;

import emitters.Utils;
import emitters.javac.Platform;
import emitters.javac.Tools;
import emitters.model.Version;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import vmodl.httpMapping;
import vmodl.internal;
import vmodl.sessionSpecific;
import vmodl.undocumented;

public class RawObject
extends emitters.model.raw.RawObject {
    private final TypeElement _typeElement;

    public RawObject() {
        this(null);
    }

    public RawObject(TypeElement typeElement) {
        this._typeElement = typeElement;
    }

    @Override
    public String getName() {
        return this._typeElement.getSimpleName().toString();
    }

    @Override
    public String getPackage() {
        Element el = this._typeElement;
        while (el.getEnclosingElement() != null && el.getKind() != ElementKind.PACKAGE) {
            el = el.getEnclosingElement();
        }
        PackageElement pkg = (PackageElement)el;
        return pkg.getQualifiedName().toString();
    }

    @Override
    public String getWsdlName() {
        return Tools.schemaTypeName(this._typeElement);
    }

    @Override
    public String getComment() {
        return Platform.getElementUtils().getDocComment(this._typeElement);
    }

    @Override
    public boolean isDeprecated() {
        return this._typeElement.getAnnotation(Deprecated.class) != null;
    }

    @Override
    public boolean isUndocumented() {
        return this._typeElement.getAnnotation(undocumented.class) != null;
    }

    @Override
    public boolean isInternal() {
        return this._typeElement.getAnnotation(internal.class) != null;
    }

    @Override
    public Version internalBefore() {
        return Tools.getInternalBefore(this._typeElement);
    }

    @Override
    public boolean isFault() {
        if (!this._typeElement.getKind().equals((Object)ElementKind.CLASS)) {
            return false;
        }
        TypeElement it = this._typeElement;
        while (it != null) {
            Name name = it.getQualifiedName();
            String className = name.toString();
            if (className.equals(Utils.MethodFaultClassName)) {
                return true;
            }
            it = this.getParent(it);
        }
        return false;
    }

    @Override
    public httpMapping.Status getHttpMapping() {
        TypeElement it = this._typeElement;
        while (it != null) {
            httpMapping httpMapping2 = it.getAnnotation(httpMapping.class);
            if (httpMapping2 != null) {
                return httpMapping2.value();
            }
            it = this.getParent(it);
        }
        return null;
    }

    private TypeElement getParent(TypeElement typeElement) {
        TypeMirror parent = typeElement.getSuperclass();
        return parent != null ? (TypeElement)Platform.getTypeUtils().asElement(parent) : null;
    }

    @Override
    public boolean isSessionSpecific() {
        return this._typeElement.getAnnotation(sessionSpecific.class) != null;
    }

    @Override
    public String getQualifiedName() {
        return this._typeElement.getQualifiedName().toString();
    }
}

