/*
 * Decompiled with CFR 0.152.
 */
package emitters.model;

import emitters.model.Version;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import emitters.model.raw.RawObject;
import emitters.model.raw.RawVersion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Enum
extends VmodlObject {
    private final List<String> _values = new ArrayList<String>();
    private final Map<String, String> _comments = new HashMap<String, String>();
    private final List<Version> _valueVersions = new ArrayList<Version>();
    private final boolean _isCppEnumClass;

    public Enum(RawObject rawObject, RawVersion rawVersion, boolean isCppEnumClass) {
        super(rawObject, rawVersion);
        this._isCppEnumClass = isCppEnumClass;
    }

    public void addValue(String value, String comment, Version version) {
        this._values.add(value);
        this._comments.put(value, comment);
        this._valueVersions.add(version);
    }

    public boolean IsCppEnumClass() {
        return this._isCppEnumClass;
    }

    public List<String> getValueList() {
        return this._values;
    }

    public List<Version> getValueVersionList() {
        return this._valueVersions;
    }

    public String getComment(String value) {
        return this._comments.get(value);
    }

    public String getValueString(String value) {
        String valueString = this._name + "_" + value;
        return valueString.toUpperCase();
    }

    @Override
    public VmodlObject.Kind getKind() {
        return VmodlObject.Kind.Enum;
    }

    public Set<VmodlDecl> getReferencedDecls(boolean wantFaults) {
        return new HashSet<VmodlDecl>();
    }

    @Override
    public void enqueueDigest() {
        super.enqueueDigest();
        for (int i = 0; i < this._values.size(); ++i) {
            Version version = this._valueVersions.get(i);
            if (version == null) {
                version = this._version;
            }
            String value = this._values.get(i);
            if (version != this._version) {
                version.enqueueDigestPartOf(this);
            }
            version.enqueueDigestEnum(value);
        }
    }

    @Override
    public void print() {
        super.print();
        System.out.print("Values:");
        for (String value : this._values) {
            System.out.print(" " + value);
        }
        System.out.println();
        System.out.print("Versions:");
        for (Version version : this._valueVersions) {
            if (version != null) {
                System.out.print(" " + version.getVmodlName());
                continue;
            }
            System.out.print(" None");
        }
        System.out.println(" ");
    }
}

