/*
 * Decompiled with CFR 0.152.
 */
package emitters.model;

import emitters.backend.Platform;
import emitters.model.SourcePos;
import emitters.model.VmodlObject;
import java.util.Comparator;

public class ObjectSourceOrderComparator
implements Comparator<VmodlObject> {
    public static final ObjectSourceOrderComparator objectSourceOrderComparator = new ObjectSourceOrderComparator();

    @Override
    public int compare(VmodlObject lhs, VmodlObject rhs) {
        if (lhs.equals(rhs)) {
            return 0;
        }
        SourcePos p1 = Platform.getSourcePos(lhs);
        SourcePos p2 = Platform.getSourcePos(rhs);
        if (p1 == null) {
            return p2 == null ? 0 : -1;
        }
        if (p2 == null) {
            return 1;
        }
        int order = p1.absoluteName.compareTo(p2.absoluteName);
        if (order == 0 && (order = p1.line - p2.line) == 0 && (order = p1.column - p2.column) == 0) {
            order = System.identityHashCode(lhs) - System.identityHashCode(rhs);
        }
        return order;
    }
}

