/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.ext;

import com.vmware.vim.vmomi.client.exception.ClientHaltException;
import com.vmware.vim.vmomi.client.ext.InvocationContext;
import com.vmware.vim.vmomi.client.ext.InvocationInterceptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AggregationInvocationInterceptor
implements InvocationInterceptor {
    private static final Log _logger = LogFactory.getLog(AggregationInvocationInterceptor.class);
    private List<InvocationInterceptor> _invocationInterceptorList = new ArrayList<InvocationInterceptor>();

    public synchronized void addInvocationInterceptor(InvocationInterceptor interceptor) {
        this._invocationInterceptorList.add(interceptor);
    }

    public synchronized void removeInvocationInterceptor(InvocationInterceptor interceptor) {
        this._invocationInterceptorList.remove(interceptor);
    }

    public List<InvocationInterceptor> getInvocationInterceptors() {
        return Collections.unmodifiableList(this._invocationInterceptorList);
    }

    @Override
    public void beginInvocation(InvocationContext invocationContext) {
        for (InvocationInterceptor invocationInterceptor : this._invocationInterceptorList) {
            try {
                invocationInterceptor.beginInvocation(invocationContext);
            }
            catch (ClientHaltException e) {
                throw e;
            }
            catch (RuntimeException e) {
                if (!_logger.isWarnEnabled()) continue;
                _logger.warn((Object)String.format("Exception in %1$s.beginInvocation()", invocationInterceptor.getClass().getName()), (Throwable)e);
            }
        }
    }

    @Override
    public void completeInvocation(InvocationContext invocationContext, boolean completionStatus) {
        for (InvocationInterceptor invocationInterceptor : this._invocationInterceptorList) {
            try {
                invocationInterceptor.completeInvocation(invocationContext, completionStatus);
            }
            catch (RuntimeException e) {
                _logger.warn((Object)String.format("Exception in %1$s.completeInvocation()", invocationInterceptor.getClass().getName()), (Throwable)e);
            }
        }
    }
}

