/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import java.io.IOException;
import java.net.NoRouteToHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.protocol.HttpContext;

public class VlsiRequestRetryHandler
implements HttpRequestRetryHandler {
    private static final Log LOG = LogFactory.getLog(VlsiRequestRetryHandler.class);
    private final HttpRequestRetryHandler _defaultHandler;
    private final int _retryLimit;

    public VlsiRequestRetryHandler(int retryLimit) {
        this._defaultHandler = new DefaultHttpRequestRetryHandler(retryLimit, false);
        this._retryLimit = retryLimit;
    }

    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        if (exception instanceof NoRouteToHostException) {
            LOG.debug((Object)"NoRouteToHostException would not be retried.");
            return false;
        }
        boolean retry = false;
        retry = this._defaultHandler.retryRequest(exception, executionCount, context);
        if (retry && LOG.isDebugEnabled()) {
            String logMessage = String.format("A retryable exception occurred.Retry %d out of %d about to be performed.", executionCount, this._retryLimit);
            LOG.debug((Object)logMessage, (Throwable)exception);
        }
        return retry;
    }
}

